import { c as create_ssr_component, e as escape, b as add_attribute, v as validate_component } from './ssr-73f02b7a.js';

const ChevronRight = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "1em" } = $$props;
  let { width = size } = $$props;
  let { height = size } = $$props;
  let { color = "currentColor" } = $$props;
  let { viewBox = "0 0 24 24" } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { ariaHidden = void 0 } = $$props;
  let { title = void 0 } = $$props;
  let { desc = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.viewBox === void 0 && $$bindings.viewBox && viewBox !== void 0)
    $$bindings.viewBox(viewBox);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0)
    $$bindings.ariaLabel(ariaLabel);
  if ($$props.ariaHidden === void 0 && $$bindings.ariaHidden && ariaHidden !== void 0)
    $$bindings.ariaHidden(ariaHidden);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  if ($$props.desc === void 0 && $$bindings.desc && desc !== void 0)
    $$bindings.desc(desc);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0)
    $$bindings.class(className);
  return `<svg${add_attribute("viewBox", viewBox, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("class", className, 0)}${add_attribute("aria-label", ariaLabel, 0)}${add_attribute("aria-hidden", ariaHidden, 0)}>${desc ? `<desc>${escape(desc)}</desc>` : ``}${title ? `<title>${escape(title)}</title>` : ``}<path d="M8.59,16.58L13.17,12L8.59,7.41L10,6L16,12L10,18L8.59,16.58Z"${add_attribute("fill", color, 0)}></path></svg>`;
});
const css = {
  code: ".wrapper.svelte-13d118m{display:flex;gap:2rem;align-items:center;padding:0.8rem 0.8rem 0.8rem 2rem;font-size:1.4rem;font-weight:700;border-radius:1rem;color:#fff;text-transform:uppercase;text-decoration:none;transition:all 0.25s;max-width:fit-content;text-align:center}.wrapper.svelte-13d118m:hover{box-shadow:0 1rem 2rem rgba(0,0,0,0.1);transform:translateY(-2px)}.wrapper.svelte-13d118m:active{box-shadow:0 0.5rem 1rem rgba(0,0,0,0.1);transform:translateY(0px)}.wrapper.blue.svelte-13d118m{background-color:#0e76bc}.wrapper.blue.svelte-13d118m:hover{background-color:#2a86c4}.wrapper.orange.svelte-13d118m{background-color:#f36d21}.wrapper.orange.svelte-13d118m:hover{background-color:#f47e3b}.wrapper.transparent.svelte-13d118m{background-color:transparent}.wrapper.white.svelte-13d118m{background-color:#fff;color:#0e76bc}.wrapper.white.svelte-13d118m:hover{background-color:#e5e5e5}.wrapper.large.svelte-13d118m{font-size:1.8rem;padding:1.4rem 0.8rem 1.4rem 2rem}.centered.svelte-13d118m{justify-content:center}",
  map: null
};
const Button = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { href = void 0 } = $$props;
  let { target = void 0 } = $$props;
  let { color = "blue" } = $$props;
  let { size = "small" } = $$props;
  let { centered = false } = $$props;
  if ($$props.href === void 0 && $$bindings.href && href !== void 0)
    $$bindings.href(href);
  if ($$props.target === void 0 && $$bindings.target && target !== void 0)
    $$bindings.target(target);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.centered === void 0 && $$bindings.centered && centered !== void 0)
    $$bindings.centered(centered);
  $$result.css.add(css);
  return `<a class="${[
    "wrapper " + escape(color, true) + " " + escape(size, true) + " svelte-13d118m",
    centered ? "centered" : ""
  ].join(" ").trim()}"${add_attribute("href", href, 0)}${add_attribute("target", target, 0)}>${slots.default ? slots.default({}) : ``} ${validate_component(ChevronRight, "ChevronRight").$$render($$result, { color: "white", size: "2.4rem" }, {}, {})} </a>`;
});

export { Button as B };
//# sourceMappingURL=Button-b4fad8e7.js.map
