import { c as create_ssr_component, e as escape, b as add_attribute, f as each } from './ssr-73f02b7a.js';

const css = {
  code: ".Hero.svelte-z513ic{height:95vh}.Hero__figure.svelte-z513ic{position:relative;display:flex;flex-direction:column;width:100%;height:100%;padding:10rem 5rem;gap:0.5rem;overflow:hidden}@media screen and (max-width: 768px){.Hero__figure.svelte-z513ic{padding:10rem 2rem}}.Hero__img.svelte-z513ic{pointer-events:none;position:absolute;width:100%;max-height:100%;z-index:-1;object-fit:cover}.Hero__title.svelte-z513ic{margin:0;padding:1rem 0;width:max-content;font-size:3.9rem;font-family:'REM Variable';text-transform:uppercase;line-height:5.4rem;display:flex;gap:5rem}@media screen and (max-width: 1024px){.Hero__title--h1.svelte-z513ic{font-size:5vw}}@media screen and (max-width: 768px){.Hero__title--h1.svelte-z513ic{display:flex;flex-direction:column;gap:1rem;font-size:3.3rem}}.Hero__title--orange.svelte-z513ic{border-radius:0.5rem;background-color:#f36d21;padding:0 0.6rem}@media screen and (max-width: 768px){.Hero__title--orange.svelte-z513ic{width:max-content;padding:0.7rem 0.6rem}}.Hero__title--blue.svelte-z513ic{border-radius:0.5rem;background-color:#0e76bc;padding:0 0.6rem}@media screen and (max-width: 768px){.Hero__title--blue.svelte-z513ic{padding:0.7rem 0.6rem;width:max-content}}.Hero__text.svelte-z513ic{font-size:1.8rem;font-weight:400;text-align:left;max-width:none;text-decoration:none;line-height:normal;margin:0;padding:0}@media screen and (max-width: 768px){.Hero__text.svelte-z513ic{font-size:1.6rem}}.Hero__text--box.svelte-z513ic{padding:2rem;max-width:80rem;background-color:rgba(0,0,0,0.251);backdrop-filter:blur(20px);border-radius:0.5rem}",
  map: null
};
const Hero = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { src } = $$props;
  let { alt } = $$props;
  let { top = 50 } = $$props;
  let { left = 50 } = $$props;
  let { translate = "-50%, -50%" } = $$props;
  if ($$props.src === void 0 && $$bindings.src && src !== void 0)
    $$bindings.src(src);
  if ($$props.alt === void 0 && $$bindings.alt && alt !== void 0)
    $$bindings.alt(alt);
  if ($$props.top === void 0 && $$bindings.top && top !== void 0)
    $$bindings.top(top);
  if ($$props.left === void 0 && $$bindings.left && left !== void 0)
    $$bindings.left(left);
  if ($$props.translate === void 0 && $$bindings.translate && translate !== void 0)
    $$bindings.translate(translate);
  $$result.css.add(css);
  return `<article class="Hero svelte-z513ic"> <figure class="Hero__figure svelte-z513ic">${typeof src === "string" ? `<img style="${"top: " + escape(top, true) + "%; left: " + escape(left, true) + "%; transform: translate(" + escape(translate, true) + ");"}" class="Hero__img svelte-z513ic"${add_attribute("alt", alt, 0)}${add_attribute("src", src.img.src, 0)}${add_attribute("width", src.img.w, 0)}${add_attribute("height", src.img.h, 0)}>` : `<picture>${each(Object.entries(src.sources), ([format, srcset]) => {
    return `<source${add_attribute("srcset", srcset, 0)}${add_attribute("type", "image/" + format, 0)}>`;
  })} <img style="${"top: " + escape(top, true) + "%; left: " + escape(left, true) + "%; transform: translate(" + escape(translate, true) + ");"}" class="Hero__img svelte-z513ic"${add_attribute("alt", alt, 0)}${add_attribute("src", src.img.src, 0)}${add_attribute("width", src.img.w, 0)}${add_attribute("height", src.img.h, 0)}></picture>`} <section class="Hero__title svelte-z513ic"><h1 class="Hero__title--h1 svelte-z513ic"><span class="Hero__title--orange svelte-z513ic">${slots.titleOne ? slots.titleOne({}) : ``}</span> <span class="Hero__title--blue svelte-z513ic">${slots.titleTwo ? slots.titleTwo({}) : ``}</span></h1></section> <section class="Hero__text--box svelte-z513ic"><p class="Hero__text svelte-z513ic">${slots.main ? slots.main({}) : ``}</p></section></figure> </article>`;
});

export { Hero as H };
//# sourceMappingURL=Hero-04d60013.js.map
