import { c as create_ssr_component, b as add_attribute, e as escape } from './ssr-73f02b7a.js';

const FridgeMagnet = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { color = "#F36D21" } = $$props;
  let { width = "16.6rem" } = $$props;
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  return `<svg fill="none" height="1.4rem" viewBox="0 0 166 14"${add_attribute("width", width, 0)} xmlns="http://www.w3.org/2000/svg"><path clip-rule="evenodd" d="M7.25586 0.0859375C3.52794 0.0859375 0.505859 3.10802 0.505859 6.83594C0.505859 10.5639 3.52794 13.5859 7.25586 13.5859H158.756C162.484 13.5859 165.506 10.5639 165.506 6.83594C165.506 3.10802 162.484 0.0859375 158.756 0.0859375H7.25586ZM24.0892 1.58594C21.1897 1.58594 18.8392 3.93644 18.8392 6.83594C18.8392 9.73543 21.1897 12.0859 24.0892 12.0859H141.923C144.822 12.0859 147.173 9.73543 147.173 6.83594C147.173 3.93644 144.822 1.58594 141.923 1.58594H24.0892Z"${add_attribute("fill", color, 0)} fill-rule="evenodd"></path></svg>`;
});
const Plus = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "1em" } = $$props;
  let { width = size } = $$props;
  let { height = size } = $$props;
  let { color = "currentColor" } = $$props;
  let { viewBox = "0 0 24 24" } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { ariaHidden = void 0 } = $$props;
  let { title = void 0 } = $$props;
  let { desc = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.viewBox === void 0 && $$bindings.viewBox && viewBox !== void 0)
    $$bindings.viewBox(viewBox);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0)
    $$bindings.ariaLabel(ariaLabel);
  if ($$props.ariaHidden === void 0 && $$bindings.ariaHidden && ariaHidden !== void 0)
    $$bindings.ariaHidden(ariaHidden);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  if ($$props.desc === void 0 && $$bindings.desc && desc !== void 0)
    $$bindings.desc(desc);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0)
    $$bindings.class(className);
  return `<svg${add_attribute("viewBox", viewBox, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("class", className, 0)}${add_attribute("aria-label", ariaLabel, 0)}${add_attribute("aria-hidden", ariaHidden, 0)}>${desc ? `<desc>${escape(desc)}</desc>` : ``}${title ? `<title>${escape(title)}</title>` : ``}<path d="M19,13H13V19H11V13H5V11H11V5H13V11H19V13Z"${add_attribute("fill", color, 0)}></path></svg>`;
});

export { FridgeMagnet as F, Plus as P };
//# sourceMappingURL=Plus-6453516c.js.map
