import { c as create_ssr_component, f as each, v as validate_component, m as missing_component, e as escape, b as add_attribute } from './ssr-73f02b7a.js';

const ArrowRight = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "1em" } = $$props;
  let { width = size } = $$props;
  let { height = size } = $$props;
  let { color = "currentColor" } = $$props;
  let { viewBox = "0 0 24 24" } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { ariaHidden = void 0 } = $$props;
  let { title = void 0 } = $$props;
  let { desc = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.viewBox === void 0 && $$bindings.viewBox && viewBox !== void 0)
    $$bindings.viewBox(viewBox);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0)
    $$bindings.ariaLabel(ariaLabel);
  if ($$props.ariaHidden === void 0 && $$bindings.ariaHidden && ariaHidden !== void 0)
    $$bindings.ariaHidden(ariaHidden);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  if ($$props.desc === void 0 && $$bindings.desc && desc !== void 0)
    $$bindings.desc(desc);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0)
    $$bindings.class(className);
  return `<svg${add_attribute("viewBox", viewBox, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("class", className, 0)}${add_attribute("aria-label", ariaLabel, 0)}${add_attribute("aria-hidden", ariaHidden, 0)}>${desc ? `<desc>${escape(desc)}</desc>` : ``}${title ? `<title>${escape(title)}</title>` : ``}<path d="M4,11V13H16L10.5,18.5L11.92,19.92L19.84,12L11.92,4.08L10.5,5.5L16,11H4Z"${add_attribute("fill", color, 0)}></path></svg>`;
});
const css = {
  code: ".Roadmap.svelte-5hv6dk.svelte-5hv6dk{background-color:#fff;border:0.3rem solid #f36d21;display:flex;flex-direction:column;width:100%;height:min-content;padding:5.4rem 8.8rem;border-radius:4rem;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1)}@media screen and (max-width: 1024px){.Roadmap.svelte-5hv6dk.svelte-5hv6dk{padding:5.4rem 0.5rem}}.Roadmap__heading.svelte-5hv6dk.svelte-5hv6dk{display:flex;flex-direction:column;align-items:center;width:100%;padding-bottom:1rem}.Roadmap__heading--h2.svelte-5hv6dk.svelte-5hv6dk{font-size:4.4rem;font-weight:700;font-family:'REM Variable';text-align:center}.Roadmap__heading--orange.svelte-5hv6dk.svelte-5hv6dk{color:#f36d21;text-decoration:underline}.Roadmap__heading--blue.svelte-5hv6dk.svelte-5hv6dk{color:#0e76bc;text-decoration:underline}.Roadmap__heading--paragraph.svelte-5hv6dk.svelte-5hv6dk{font-size:1.8rem;font-weight:400;color:#15181c;text-align:center;max-width:50rem;line-height:normal}.Roadmap__cards.svelte-5hv6dk.svelte-5hv6dk{display:flex;flex-direction:column;gap:1rem}.Roadmap__card.svelte-5hv6dk.svelte-5hv6dk{display:grid;grid-template-columns:repeat(auto-fit, minmax(1rem, 1fr));background-color:#f36d21;border-radius:2.6rem;padding:2rem;align-items:center;justify-items:center}.Roadmap__card.svelte-5hv6dk p.svelte-5hv6dk{margin:0}.Roadmap__card--slot.svelte-5hv6dk.svelte-5hv6dk{display:flex;flex-direction:column;align-items:center;justify-content:center;gap:1rem;width:11rem}@media screen and (max-width: 640px){.Roadmap__card--slot.svelte-5hv6dk.svelte-5hv6dk{width:10rem}}.Roadmap__card--text.svelte-5hv6dk.svelte-5hv6dk{font-size:1.4rem;font-weight:600;text-align:center;text-transform:uppercase}@media screen and (max-width: 640px){.Roadmap__card--text.svelte-5hv6dk.svelte-5hv6dk{font-size:1rem;width:min-content}}.blue.svelte-5hv6dk.svelte-5hv6dk{background-color:#0e76bc}",
  map: null
};
const Roadmap = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { stages } = $$props;
  if ($$props.stages === void 0 && $$bindings.stages && stages !== void 0)
    $$bindings.stages(stages);
  $$result.css.add(css);
  return `<article class="Roadmap svelte-5hv6dk"><section class="Roadmap__heading svelte-5hv6dk" data-svelte-h="svelte-54oxbg"><h2 class="Roadmap__heading--h2 svelte-5hv6dk"><span class="Roadmap__heading--orange svelte-5hv6dk">Your</span> <span class="Roadmap__heading--blue svelte-5hv6dk">Roadmap</span></h2> <p class="Roadmap__heading--paragraph svelte-5hv6dk">Aviation pathways can be very overwhelming, don&#39;t worry, we&#39;ll be with you
            every step of the way</p></section> <div class="Roadmap__cards svelte-5hv6dk">${each(stages, (stage, i1) => {
    return `<section class="${["Roadmap__card svelte-5hv6dk", i1 % 2 === 1 ? "blue" : ""].join(" ").trim()}">${each(stage, (task, i2) => {
      return `<div class="Roadmap__card--slot svelte-5hv6dk"><div class="Roadmap__card--img">${validate_component(task.icon || missing_component, "svelte:component").$$render($$result, { size: "4rem" }, {}, {})}</div> <p class="Roadmap__card--text svelte-5hv6dk">${escape(task.label)} </p></div> ${i2 !== stage.length - 1 ? `<div class="Roadmap__card--arrow">${validate_component(ArrowRight, "ArrowRight").$$render($$result, { color: "white", size: "4rem" }, {}, {})} </div>` : ``}`;
    })} </section>`;
  })}</div> </article>`;
});

export { Roadmap as R };
//# sourceMappingURL=Roadmap-b89b5076.js.map
