import { c as create_ssr_component, v as validate_component, d as add_styles, b as add_attribute, e as escape } from './ssr-73f02b7a.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { F as FunnelCard } from './FunnelCard-7733fd41.js';
import { R as Reviews, C as Contact } from './Contact-67961899.js';
import './Button-b4fad8e7.js';

const css$1 = {
  code: ".CareerMission.svelte-e9rd10.svelte-e9rd10{position:relative;height:100vh;overflow:hidden;width:100%}.CareerMission__img.svelte-e9rd10.svelte-e9rd10{position:absolute;height:100%;width:100%;object-fit:cover;top:50%;left:50%;transform:translate(-50%, -50%);z-index:-1}.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{color:#0e76bc;font-size:8rem;font-weight:800;text-transform:uppercase;display:flex;flex-direction:column;align-items:flex-start;font-family:'REM Variable';padding:10rem 5rem}@media screen and (max-width: 1536px){.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{font-size:6.5rem}}@media screen and (max-width: 1280px){.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{font-size:5.5rem;padding-top:5rem}}@media screen and (max-width: 768px){.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{align-items:center}}@media screen and (max-width: 640px){.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{font-size:4.5rem;padding:0;align-items:center;padding-top:10rem}}.CareerMission__h2.svelte-e9rd10 span.svelte-e9rd10{color:#fff}",
  map: null
};
const Comp = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$1);
  return `<article class="CareerMission svelte-e9rd10" data-svelte-h="svelte-1mo17li"><figure class="CareerMission__figure"><picture><source${add_attribute("srcset", "/_app/immutable/assets/Landscape2.4223541d.avif 1x, /_app/immutable/assets/Landscape2.02e140f5.avif 2x", 0)} type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/Landscape2.1e7dc5dc.webp 1x, /_app/immutable/assets/Landscape2.4ed7f3a2.webp 2x", 0)} type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/Landscape2.0f6f7adc.jpg 1x, /_app/immutable/assets/Landscape2.275e4172.jpg 2x", 0)} type="image/jpeg"><img class="CareerMission__img svelte-e9rd10" alt="The GOAT" size="100vw" src="/_app/immutable/assets/Landscape2.275e4172.jpg" width="6000" height="4000"></picture> <h2 class="CareerMission__h2 svelte-e9rd10">Dedicated <span class="svelte-e9rd10">Training</span></h2></figure> </article>`;
});
const ShieldLockOutline = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "1em" } = $$props;
  let { width = size } = $$props;
  let { height = size } = $$props;
  let { color = "currentColor" } = $$props;
  let { viewBox = "0 0 24 24" } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { ariaHidden = void 0 } = $$props;
  let { title = void 0 } = $$props;
  let { desc = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.viewBox === void 0 && $$bindings.viewBox && viewBox !== void 0)
    $$bindings.viewBox(viewBox);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0)
    $$bindings.ariaLabel(ariaLabel);
  if ($$props.ariaHidden === void 0 && $$bindings.ariaHidden && ariaHidden !== void 0)
    $$bindings.ariaHidden(ariaHidden);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  if ($$props.desc === void 0 && $$bindings.desc && desc !== void 0)
    $$bindings.desc(desc);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0)
    $$bindings.class(className);
  return `<svg${add_attribute("viewBox", viewBox, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("class", className, 0)}${add_attribute("aria-label", ariaLabel, 0)}${add_attribute("aria-hidden", ariaHidden, 0)}>${desc ? `<desc>${escape(desc)}</desc>` : ``}${title ? `<title>${escape(title)}</title>` : ``}<path d="M21,11C21,16.55 17.16,21.74 12,23C6.84,21.74 3,16.55 3,11V5L12,1L21,5V11M12,21C15.75,20 19,15.54 19,11.22V6.3L12,3.18L5,6.3V11.22C5,15.54 8.25,20 12,21M14.8,11V9.5C14.8,8.1 13.4,7 12,7C10.6,7 9.2,8.1 9.2,9.5V11C8.6,11 8,11.6 8,12.2V15.7C8,16.4 8.6,17 9.2,17H14.7C15.4,17 16,16.4 16,15.8V12.3C16,11.6 15.4,11 14.8,11M13.5,11H10.5V9.5C10.5,8.7 11.2,8.2 12,8.2C12.8,8.2 13.5,8.7 13.5,9.5V11Z"${add_attribute("fill", color, 0)}></path></svg>`;
});
const ChevronTripleUp = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "1em" } = $$props;
  let { width = size } = $$props;
  let { height = size } = $$props;
  let { color = "currentColor" } = $$props;
  let { viewBox = "0 0 24 24" } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { ariaHidden = void 0 } = $$props;
  let { title = void 0 } = $$props;
  let { desc = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.viewBox === void 0 && $$bindings.viewBox && viewBox !== void 0)
    $$bindings.viewBox(viewBox);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0)
    $$bindings.ariaLabel(ariaLabel);
  if ($$props.ariaHidden === void 0 && $$bindings.ariaHidden && ariaHidden !== void 0)
    $$bindings.ariaHidden(ariaHidden);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  if ($$props.desc === void 0 && $$bindings.desc && desc !== void 0)
    $$bindings.desc(desc);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0)
    $$bindings.class(className);
  return `<svg${add_attribute("viewBox", viewBox, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("class", className, 0)}${add_attribute("aria-label", ariaLabel, 0)}${add_attribute("aria-hidden", ariaHidden, 0)}>${desc ? `<desc>${escape(desc)}</desc>` : ``}${title ? `<title>${escape(title)}</title>` : ``}<path d="M16.59,9.42L12,4.83L7.41,9.42L6,8L12,2L18,8L16.59,9.42M16.59,15.42L12,10.83L7.41,15.42L6,14L12,8L18,14L16.59,15.42M16.59,21.42L12,16.83L7.41,21.42L6,20L12,14L18,20L16.59,21.42Z"${add_attribute("fill", color, 0)}></path></svg>`;
});
const DiamondStone = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "1em" } = $$props;
  let { width = size } = $$props;
  let { height = size } = $$props;
  let { color = "currentColor" } = $$props;
  let { viewBox = "0 0 24 24" } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { ariaHidden = void 0 } = $$props;
  let { title = void 0 } = $$props;
  let { desc = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.viewBox === void 0 && $$bindings.viewBox && viewBox !== void 0)
    $$bindings.viewBox(viewBox);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0)
    $$bindings.ariaLabel(ariaLabel);
  if ($$props.ariaHidden === void 0 && $$bindings.ariaHidden && ariaHidden !== void 0)
    $$bindings.ariaHidden(ariaHidden);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  if ($$props.desc === void 0 && $$bindings.desc && desc !== void 0)
    $$bindings.desc(desc);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0)
    $$bindings.class(className);
  return `<svg${add_attribute("viewBox", viewBox, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("class", className, 0)}${add_attribute("aria-label", ariaLabel, 0)}${add_attribute("aria-hidden", ariaHidden, 0)}>${desc ? `<desc>${escape(desc)}</desc>` : ``}${title ? `<title>${escape(title)}</title>` : ``}<path d="M16,9H19L14,16M10,9H14L12,17M5,9H8L10,16M15,4H17L19,7H16M11,4H13L14,7H10M7,4H9L8,7H5M6,2L2,8L12,22L22,8L18,2H6Z"${add_attribute("fill", color, 0)}></path></svg>`;
});
const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/Landscape4.0946fddd.avif 1x, /_app/immutable/assets/Landscape4.87bb9d53.avif 2x",
    webp: "/_app/immutable/assets/Landscape4.3bb20b78.webp 1x, /_app/immutable/assets/Landscape4.1a312f02.webp 2x",
    jpeg: "/_app/immutable/assets/Landscape4.b4c899be.jpg 1x, /_app/immutable/assets/Landscape4.8102f417.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/Landscape4.8102f417.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src1 = {
  sources: {
    avif: "/_app/immutable/assets/adam.7efbb5a3.avif 1x, /_app/immutable/assets/adam.02f04de1.avif 1.999361430395913x",
    webp: "/_app/immutable/assets/adam.bb9a2d51.webp 1x, /_app/immutable/assets/adam.3a284334.webp 1.999361430395913x",
    jpeg: "/_app/immutable/assets/adam.05b9dea5.jpg 1x, /_app/immutable/assets/adam.efee7a8b.jpg 1.999361430395913x"
  },
  img: {
    src: "/_app/immutable/assets/adam.efee7a8b.jpg",
    w: 3131,
    h: 4299
  }
};
const css = {
  code: ".funnel.svelte-1hcbsy{display:grid;grid-template-columns:1fr 1fr 1fr;gap:2.5rem;padding:10rem 5rem}@media screen and (max-width: 1280px){.funnel.svelte-1hcbsy{display:flex;flex-direction:column}}@media screen and (max-width: 1024px){.funnel.svelte-1hcbsy{gap:2rem;padding:5rem 2rem}}.card.svelte-1hcbsy{padding:10rem 5rem}.card__two.svelte-1hcbsy{padding:10rem 0rem}",
  map: null
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css);
  return `${$$result.head += `<!-- HEAD_svelte-n54821_START -->${$$result.title = `<title>About Us | First Landings Aviation</title>`, ""}<meta name="description" content="About First Landings Aviation"><!-- HEAD_svelte-n54821_END -->`, ""} ${validate_component(Hero, "Hero").$$render(
    $$result,
    {
      alt: "",
      src: hero_src,
      top: 0,
      translate: "-50%, 0"
    },
    {},
    {
      main: () => {
        return `<div slot="main" data-svelte-h="svelte-19xvwnj">First Landings, where aviation dreams take flight! Established with a passion for empowering
		aspiring aviators, we are dedicated to providing a top-tier flight training experience that
		transcends boundaries and elevates careers.</div>`;
      },
      titleTwo: () => {
        return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1hk2t7o">First Landings</span>`;
      },
      titleOne: () => {
        return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1sw5qnz">About</span>`;
      }
    }
  )} <article class="funnel svelte-1hcbsy">${validate_component(FunnelCard, "FunnelCard").$$render($$result, { icon: true }, {}, {
    icon: () => {
      return `<div slot="icon"${add_styles({ "height": `inherit` })}>${validate_component(ShieldLockOutline, "ShieldLockOutline").$$render($$result, { size: "17rem" }, {}, {})}</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-zx3mi">At First Landings, trust is the cornerstone of our operations. We understand that
			embarking on a journey into the skies requires a foundation built on reliability,
			safety, and integrity. We take immense pride in the trust our students and their
			families place in us, and we are committed to upholding the highest standards of
			excellence throughout their aviation education.
			<br> <br>
			With countless alumni in the air, you can trust First Landings to help you earn your wings.</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-1s6mbg3">Trust</div>`;
    }
  })} ${validate_component(FunnelCard, "FunnelCard").$$render($$result, { icon: true }, {}, {
    icon: () => {
      return `<div slot="icon"${add_styles({ "height": `inherit` })}>${validate_component(ChevronTripleUp, "ChevronTripleUp").$$render($$result, { size: "17rem" }, {}, {})}</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-wqg8k6">We have strict standards and only employ the most qualified instructors.  They are
			valued members of the First Landings team and are consistently motivated to helping you
			succeed.
			<br> <br>
			Our team of flight instructors are not only highly experienced but also hold the necessary
			certifications and qualifications to guide students through their aviation training. Their
			dedication to excellence, paired with a passion for aviation, ensures that each student receives
			personalized and expert instruction throughout their journey with us.</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-1pzg0r7">Experience</div>`;
    }
  })} ${validate_component(FunnelCard, "FunnelCard").$$render($$result, { icon: true }, {}, {
    icon: () => {
      return `<div slot="icon"${add_styles({ "height": `inherit` })}>${validate_component(DiamondStone, "DiamondStone").$$render($$result, { size: "17rem" }, {}, {})}</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-179d87t">You have a lot of options in your flight training. First Landings strives to create
			incredible value, providing you with competitive pricing and top  quality. Fly with
			confidence at First Landings Aviation, where we strive to be your long term aviation
			partner.  
			<br> <br>
			We believe in providing you the best flight training experience possible and commit to being
			with you on this journey. Our certified mechanics, flight instructors and support staff are
			solely focused on your safety and success.</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-8xd5pu">Value</div>`;
    }
  })}</article> ${validate_component(Comp, "Comp").$$render($$result, {}, {}, {})} <div class="card svelte-1hcbsy">${validate_component(ContentCard, "ContentCard").$$render($$result, { alt: "Adam Valencic", src: content_src1 }, {}, {
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-164jxf4">At First Landings, we understand that the sky is not just a limit; it&#39;s a boundless
			canvas waiting to be explored. Our team of highly experienced and certified flight
			instructors are committed to guiding you through every phase of your aviation journey,
			from your first exhilarating takeoff to mastering the intricacies of advanced flight
			maneuvers.
			<br> <br>
			What sets us apart is our unwavering commitment to safety, excellence, and personalized instruction.
			We believe that each student is unique, and our tailored training programs reflect this philosophy.
			Whether you are pursuing a private pilot&#39;s license for recreational purposes or aspiring
			to become a professional pilot, we have the expertise and resources to help you achieve your
			goals.
			<br> <br>
			Embark on your aviation journey with First Landings, where the sky is not just the limit—it&#39;s
			your new beginning. Join us, and together, let&#39;s soar to new heights!</div>`;
    },
    title: () => {
      return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-v91u4f">Established 2009</span>`;
    }
  })} <div class="card__two svelte-1hcbsy">${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-1uu05rd">There are many flight schools in Florida that students can choose to learn to fly –
				ranging in size from schools with 5 airplanes to schools with 40 plus airplanes.
				<br> <br>
				So, as a prospective student, what do we at First Landings Aviation, offer you that sets
				us apart?
				<br> <br> <ol><li><b>Longevity in Business</b> <br>
						We have been providing professional flight training since 2009.</li> <br> <li><b>Location</b> <br>
						We are located near Orlando in Central Florida at Apopka (X04), at an uncontrolled
						airfield. Other flight schools are located in large Class C or D airports, which
						may require 20 minutes-plus to taxi to an active runway before taking off – and
						then an additional 5 to 10 minutes of flight to travel to the ‘practice area’.
						Our typical taxi time is less than 3 minutes, and our practice area is 1 minute
						from the airport.
						<br> <br>
						Why is important? In a 2 hour lesson, we spend nearly all the time flying, rather
						than 20% to 25% on the ground – this translates to approximately 50 to 60 hours
						of additional flight time, which gains the student more flight experience.</li> <br> <li><b>Part 141 international students only need 190 hours</b> <br>
						International students can obtain their FAA commercial Single Engine Land in
						190 hours, as compared to the typical 250 hours.</li> <br> <li><b>Modern Fleet of Aircraft</b> <br>
						First Landings has new Piper PA-28-181 Pilots 100i’s, Technically Advanced Aircraft
						(TAA), with Garmin G3X digital touch-screens and integrated digital avionics
						and autopilot, and the Tecnam P2006t multi-engine with duel digital G950’s and
						autopilots. We also have several Cessna 172’s and Tecnam P92’s.</li> <br> <li><b>Experienced Chief Pilot and Check Pilots</b> <br>
						Our Chief Pilot has over 33,000 flight hours, and over 12,000 dual instruction,
						and all our Check Pilots have over 800 hours minimum to qualify.</li> <br> <li><b>Standardized Training with our Certified Flight Instructors</b> <br>
						All new instructors are required to undergo internal training to meet our company
						standards, which when coupled with our structured training and stage checks,
						results in the same standards and level of training from all our instructors.</li> <br> <li><b>Personalized Training Experience</b> <br>
						Our approach is to develop custom, tailored training schedules for each student.
						Everybody learns in a different way, and rather than a regimented linear training
						schedule that requires the student to meet all of the standards or risk failing,
						we strive to understand what the underlying issues are, and work with students
						to develop strategies to help them overcome their various training obstacles.</li> <br> <li><b>Accelerated Flight Training Program</b> <br>
						For the serious students who want to achieve their single and multi-engine Commercial
						certificate, our accelerated program can graduate students with no flight experience
						in as little 4 months.</li> <br> <li><b>Standard Flight Training Program</b> <br>
						Our standard single and multi-engine Commercial program typically graduates students
						in 6 to 8 months.</li> <br> <li><b>Cost Effective Programs</b> <br>
						All our programs include the equipment, exams, aircraft rental and instructor
						costs, and are competitively priced.</li></ol></div>`;
    },
    title: () => {
      return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-15d0ghq">Why First Landings</span>`;
    }
  })}</div></div> ${validate_component(Reviews, "Reviews").$$render($$result, {}, {}, {})} ${validate_component(Contact, "Contact").$$render($$result, {}, {}, {})}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-1d0f9c2a.js.map
