import { c as create_ssr_component, v as validate_component, d as add_styles } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { R as Roadmap } from './Roadmap-b89b5076.js';
import { I as Image } from './Image-c986cba7.js';
import { A as AirplaneTakeoff } from './AirplaneTakeoff-bb9ec5c6.js';
import { H as HumanMaleBoard, N as NotebookCheckOutline, A as AccountSupervisor, B as BookEducation, S as School, a as AccountTieHat } from './School-36f73e07.js';

const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/instructors.f1140e4c.avif 1x, /_app/immutable/assets/instructors.ca0958ff.avif 2x",
    webp: "/_app/immutable/assets/instructors.2a82ae2a.webp 1x, /_app/immutable/assets/instructors.b9d3c963.webp 2x",
    jpeg: "/_app/immutable/assets/instructors.78176925.jpg 1x, /_app/immutable/assets/instructors.5c500eaa.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/instructors.5c500eaa.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src1 = {
  sources: {
    avif: "/_app/immutable/assets/instructor_ingress.0478f45b.avif 1x, /_app/immutable/assets/instructor_ingress.2b354e78.avif 2x",
    webp: "/_app/immutable/assets/instructor_ingress.378137ae.webp 1x, /_app/immutable/assets/instructor_ingress.2e74c13e.webp 2x",
    jpeg: "/_app/immutable/assets/instructor_ingress.ad3504b8.jpg 1x, /_app/immutable/assets/instructor_ingress.5406211d.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/instructor_ingress.5406211d.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src2 = {
  sources: {
    avif: "/_app/immutable/assets/eb.bc0e1d18.avif 1x, /_app/immutable/assets/eb.7747bf8f.avif 2x",
    webp: "/_app/immutable/assets/eb.de78e91e.webp 1x, /_app/immutable/assets/eb.48e29f75.webp 2x",
    jpeg: "/_app/immutable/assets/eb.13e6fb59.jpg 1x, /_app/immutable/assets/eb.6a282fce.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/eb.6a282fce.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src3 = {
  sources: {
    avif: "/_app/immutable/assets/neo.d6a0ffd7.avif 1x, /_app/immutable/assets/neo.161f6377.avif 2x",
    webp: "/_app/immutable/assets/neo.f4b90b54.webp 1x, /_app/immutable/assets/neo.7c36626c.webp 2x",
    jpeg: "/_app/immutable/assets/neo.d5b734e4.jpg 1x, /_app/immutable/assets/neo.e45c873b.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/neo.e45c873b.jpg",
    w: 6e3,
    h: 4e3
  }
};
const image_src = {
  sources: {
    avif: "/_app/immutable/assets/maverick_teaching.c59d4cd8.avif 1x, /_app/immutable/assets/maverick_teaching.9c08c468.avif 2x",
    webp: "/_app/immutable/assets/maverick_teaching.00835744.webp 1x, /_app/immutable/assets/maverick_teaching.eca26113.webp 2x",
    jpeg: "/_app/immutable/assets/maverick_teaching.0e7cd595.jpg 1x, /_app/immutable/assets/maverick_teaching.24d68488.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/maverick_teaching.24d68488.jpg",
    w: 6e3,
    h: 4e3
  }
};
const css = {
  code: ".heading.svelte-117fmts{color:#15181c;font-size:3rem}",
  map: null
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let stages = [
    [
      {
        label: "CFI Training",
        icon: HumanMaleBoard
      },
      {
        label: "CFI Checkride",
        icon: NotebookCheckOutline
      },
      {
        label: "Start Instructing Students",
        icon: AccountSupervisor
      },
      {
        label: "CFII Course",
        icon: BookEducation
      }
    ],
    [
      {
        label: "CFII Checkride",
        icon: AirplaneTakeoff
      },
      { label: "MEI Course", icon: School },
      {
        label: "MEI Checkride",
        icon: AirplaneTakeoff
      },
      {
        label: "1500 Hours Start your career",
        icon: AccountTieHat
      }
    ]
  ];
  $$result.css.add(css);
  return `${$$result.head += `<!-- HEAD_svelte-7o1avd_START -->${$$result.title = `<title>Flight Instructor | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation flight instructor training"><!-- HEAD_svelte-7o1avd_END -->`, ""} ${validate_component(Hero, "Hero").$$render($$result, { alt: "", src: hero_src }, {}, {
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-4br0sg">Our CFI course enables you to instruct and mentor aspiring pilots while gaining excellent
        experience as PIC and accumulating flight hours, paving the way for furthering career
        opportunities. Certified flight instructor jobs include teaching FAA PPL and CPL.</div>`;
    },
    titleTwo: () => {
      return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1oo8vty">Program</span>`;
    },
    titleOne: () => {
      return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1jz3n1r">Flight Instructor</span>`;
    }
  })} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `<h2 class="heading svelte-117fmts" data-svelte-h="svelte-1pqz82j">Certified Flight Instructor</h2> ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-9zua7c">This CFI course is designed to take a Commercial Pilot single or multi engine airplane
            certificate holder to the completion of the Certified Flight Instructor (CFI)
            Certificate.
            <br> <br>
            Most professional pilots and airline pilots have spent their time as flight instructors.
            There really is no other better option than being a flight instructor to gain all that experience
            and flight time necessary to advance on to the other professional pilot careers.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1vy11x7">Course Description</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "First Landings instructor piper pilot 100i",
          src: content_src1
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-1db81hy">A current FAA Commercial Pilot certificate (or ATP) with Airplane Category (ASEL or
            AMEL).
            <br> <br>
            A minimum of class III medical certificate, valid. Basic Med is acceptable.
            <br> <br>
            FIA and FOI exam passed (preferred, but not required), or Ground Instructor in lieu of FOI.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1uihprt">Prerequisites</span>`;
          }
        }
      )} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-1kmiifh">Our CFI initial course is a very detailed, thorough, and hands-on course, and requires a
            lot of hard work and time on the part of the applicant as well as the instructors. The
            course is about 10-12 hours of flight training, and 60-80 hours of ground school. You
            need to keep in mind that this training is about being able to teach aviation, both on
            the ground and in flight. This course is not about your piloting skills. We understand
            that you already hold at least a commercial pilot certificate, hence you already have
            mastered the art of flying. Now it is about mastering the art of teaching aviation.
            <br> <br>
            The 60+ hours of the ground school includes all the subject areas covered in the Fundamentals
            of Instruction and the Flight Instructor Aeronautical Knowledge. You will have to spend a
            lot of time yourself for self-study, and also practice teaching other students while your
            instructor is supervising. By the time you are ready for your FAA checkride you will have
            gained all the knowledge and confidence necessary to qualify as a flight instructor and teach
            others how to fly.
            <br> <br>
            The Flight portion of the course includes all the Private, Commercial, and CFI maneuvers,
            with you teaching from the right seat. The course also includes the required spin awareness,
            entry, and recovery techniques. At the completion of the course, you will have all the skills
            and confidence necessary to teach another pilot while sitting in the right seat of an airplane.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-flft2m">Course Structure</span>`;
        }
      })} <h2 class="heading svelte-117fmts" data-svelte-h="svelte-dpsulj">Certified Flight Instructor - Instrument</h2> ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-w4ugx5">This is an add on course to an existing Flight Instructor certificate.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1vy11x7">Course Description</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "First Landings instructor",
          src: content_src2
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-1rgqymb">A current FAA Certificated Flight Instructor certificate with Airplane Category (ASE or
            AME).
            <br> <br>
            A minimum of class III medical certificate, valid. Basic Med is acceptable.
            <br> <br>
            FII written exam passed (preferred, but not required).</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1uihprt">Prerequisites</span>`;
          }
        }
      )} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-v30hv4">Our CFII add on course is pretty straight forward – we will train you and get you ready
            for the Flight Instructor Instrument Airplane practical test.
            <br> <br>
            Ground and Flight Instruction is provided by qualified and experienced instructors. Lesson
            plans and reference materials is included in the ground portion of this course.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-flft2m">Course Structure</span>`;
        }
      })} <h2 class="heading svelte-117fmts" data-svelte-h="svelte-118323j">Multi Engine Instructor</h2> ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-1eenxjw">This MEI course is a training course to help you add Multi Engine Rating on your
            existing FAA Flight Instructor certificate. You must have 10 hours PIC in a multi-engine
            airplane at the time of starting this course. If not, please add extra day for each 5
            hours missing.
            <br> <br>
            Checkride is scheduled and completed on the 4th day. Our MEI course is 3 days of ground and
            flight training and immediately followed by a checkride with a DPE on the 4th day. Checkrides
            are pre-scheduled.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1vy11x7">Course Description</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "First Landings multi engine instructor - the machine",
          src: content_src3
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-1n6jhg3">A current or expired FAA Flight Instructor certificate (CFI).
            <br> <br>
            A minimum of class III medical certificate, valid. Basic Med is acceptable.
            <br> <br>
            There is no written exam for this add-on course.
            <br> <br>
            10 hours PIC in multi-engine aircraft.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1uihprt">Prerequisites</span>`;
          }
        }
      )} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-15uge18">Our MEI add-on course includes about 10 hours of ground training and about 5 hours of
            flight training covering the multi-engine course materials.
            <br> <br>
            Lesson plans are provided as part of the ground school. You will have 2 ground sessions and
            1-2 flight training sessions per day.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-flft2m">Course Structure</span>`;
        }
      })} ${validate_component(Roadmap, "Roadmap").$$render($$result, { stages }, {}, {})} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-k4xgje">A check-ride is an essential part of the pilot certification process that includes both
            a flight test and an oral exam. During a check-ride, a designated pilot examiner (DPE)
            assesses the pilot&#39;s ability to operate an aircraft safely and proficiently. The
            examination covers various aspects, including flight maneuvers, navigation, emergency
            procedures, communication skills, and a thorough understanding of aviation regulations.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-cuvss2">Checkride Information</span>`;
        }
      })} ${validate_component(Image, "Image").$$render(
        $$result,
        {
          alt: "First Landings flight instructor teaching student",
          src: image_src
        },
        {},
        {}
      )}`;
    }
  })}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-6a3bade7.js.map
