import { c as create_ssr_component, v as validate_component, d as add_styles } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { R as Roadmap } from './Roadmap-b89b5076.js';
import { P as Prerequisites } from './Prerequisites-09460ce9.js';
import { A as AccountCowboyHatOutline } from './AccountCowboyHatOutline-388465b7.js';
import { B as BookOpenPageVariant } from './BookOpenPageVariant-8d667132.js';
import { A as AirplaneTakeoff } from './AirplaneTakeoff-bb9ec5c6.js';
import { C as CheckDecagram } from './CheckDecagram-6513be28.js';

const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/eaglet_roll.73b77808.avif 1x, /_app/immutable/assets/eaglet_roll.8ace99aa.avif 2x",
    webp: "/_app/immutable/assets/eaglet_roll.44cd0725.webp 1x, /_app/immutable/assets/eaglet_roll.176d137f.webp 2x",
    jpeg: "/_app/immutable/assets/eaglet_roll.bdd50a03.jpg 1x, /_app/immutable/assets/eaglet_roll.ba9d95e0.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/eaglet_roll.ba9d95e0.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src1 = {
  sources: {
    avif: "/_app/immutable/assets/eaglet_holdshort.0d0a40ac.avif 1x, /_app/immutable/assets/eaglet_holdshort.49488129.avif 2x",
    webp: "/_app/immutable/assets/eaglet_holdshort.dd6d5657.webp 1x, /_app/immutable/assets/eaglet_holdshort.0a6d2c2e.webp 2x",
    jpeg: "/_app/immutable/assets/eaglet_holdshort.d68de3d2.jpg 1x, /_app/immutable/assets/eaglet_holdshort.9aec4282.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/eaglet_holdshort.9aec4282.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src2 = {
  sources: {
    avif: "/_app/immutable/assets/eaglet_runway.7f799811.avif 1x, /_app/immutable/assets/eaglet_runway.45bea653.avif 2x",
    webp: "/_app/immutable/assets/eaglet_runway.54b7dbda.webp 1x, /_app/immutable/assets/eaglet_runway.ac2e1a7f.webp 2x",
    jpeg: "/_app/immutable/assets/eaglet_runway.fdd88d35.jpg 1x, /_app/immutable/assets/eaglet_runway.19a5017a.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/eaglet_runway.19a5017a.jpg",
    w: 6e3,
    h: 4e3
  }
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let stages = [
    [
      {
        label: "Orientation / Discovery flight",
        icon: AccountCowboyHatOutline
      },
      {
        label: "Sport Pilot Training",
        icon: BookOpenPageVariant
      },
      {
        label: "Sport Pilot Checkride",
        icon: AirplaneTakeoff
      },
      {
        label: "Sport Pilot Acheived",
        icon: CheckDecagram
      }
    ]
  ];
  let prerequisites = {
    eligibility: [
      "Be at least 17 years old",
      "Be able to read, speak, write, and understand the English language proficiently",
      "Hold a U.S. student pilot pilot certificate",
      "Receive ground training or home study the required aeronautical knowledge",
      "Have an instructor certifying that you are prepared for the required knowledge test",
      "Have an instructor certify that you are prepared for the practical test",
      "Pass the knowledge test on aeronautical knowledge",
      "Have received flight training from a certified flight instructor in areas of operation (listed below)",
      "Pass the practical test"
    ],
    proficiency: [
      "Preflight preparation",
      "Preflight procedures",
      "Airport operations",
      "Takeoffs, landings, and go-arounds",
      "Performance maneuvers",
      "Ground reference maneuvers",
      "Navigation",
      "Slow flight and stalls",
      "Emergency operations",
      "Post-flight procedures"
    ],
    experience: [
      "20 hours of flight time",
      "15 hours of flight training",
      "5 hours of solo flight training",
      "2 hours of cross-country flight training",
      "10 takeoffs and landings to a full stop",
      "One solo cross-country flight of at least 75 nautical miles total distance, with a full-stop landing at a minimum of two points and one segment of the flight consisting of a straight-line distance of at least 25 nautical miles between the takeoff and landing locations",
      "2 hours of flight training with an authorized instructor on those areas of operation within the preceding 2 calendar months from the month of the test"
    ]
  };
  return `${$$result.head += `<!-- HEAD_svelte-myhhld_START -->${$$result.title = `<title>Sport Pilot | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation sport pilot training"><!-- HEAD_svelte-myhhld_END -->`, ""} ${validate_component(Hero, "Hero").$$render($$result, { alt: "", src: hero_src }, {}, {
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-xahuzv">The Sport Pilot certificate represents a new way to fly that is safe, fun, and more
        affordable. It allows those interested in flight to obtain their rating in half the time and
        for half the cost of the traditional Private Pilot certificate. So climb aboard, take the
        controls, and launch into new adventures in aviation today.</div>`;
    },
    titleTwo: () => {
      return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-16bqbb0">Pilot Program</span>`;
    },
    titleOne: () => {
      return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-ey376">Sport</span>`;
    }
  })} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "P92 holding short",
          src: content_src1
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-w0ded4">First Landings Aviation became Central Florida’s first sport pilot training center in
            May of 2009. Since then, we have taught more sport pilots to fly than any other flight
            schools in the country. Our alumni come from nearly all 50 states, and several countries
            around the world. This course will give you the knowledge and experience to earn your
            certificate and become a safe operating pilot in the aviation world. You can schedule
            your flights as you have availability, and make flying your new leisure activity - It’s
            completely up to you how long your program takes! All your efforts will concentrate on
            training you to be a safe, responsible, and experienced Sport Pilot ready to pass the
            FAA practical test. Our facilities also include a luxurious pilot’s lounge and area for
            students to study and work with each other while here.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1vy11x7">Course Description</span>`;
          }
        }
      )} ${validate_component(Roadmap, "Roadmap").$$render($$result, { stages }, {}, {})} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-o7b0fw">In order to begin your training you must be able to read, write, speak and understand
            English proficiently. Either a FAA issued medical certificate or a US drivers license is
            needed. You will also need to show proof of U.S. Citizenship or TSA approval as well as
            your student pilot certificate.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-17oidz4">What Do You Need to Start?</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "Tecnam P92 Eaglet entering runway",
          src: content_src2
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-k4xgje">A check-ride is an essential part of the pilot certification process that includes both
            a flight test and an oral exam. During a check-ride, a designated pilot examiner (DPE)
            assesses the pilot&#39;s ability to operate an aircraft safely and proficiently. The
            examination covers various aspects, including flight maneuvers, navigation, emergency
            procedures, communication skills, and a thorough understanding of aviation regulations.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-cuvss2">Checkride Information</span>`;
          }
        }
      )} ${validate_component(Prerequisites, "Prerequisites").$$render($$result, { prerequisites }, {}, {})}`;
    }
  })}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-77a16709.js.map
