import { c as create_ssr_component, v as validate_component, b as add_attribute, d as add_styles } from './ssr-73f02b7a.js';
import { F as FunnelCard } from './FunnelCard-7733fd41.js';
import { B as Button } from './Button-b4fad8e7.js';
import { F as Financing } from './Financing-541250c1.js';
import { R as Reviews, C as Contact } from './Contact-67961899.js';
import './four_planes-09dc2ee5.js';

const src = "/_app/immutable/assets/hero_video.899fae85.webm";
const css$7 = {
  code: '.hero__container.svelte-1iae16o{position:relative;overflow:hidden;height:95vh;width:100%}@media screen and (max-width: 1024px){.hero__container.svelte-1iae16o{background-image:url("/sunset.webp");background-size:cover}}.hero__video.svelte-1iae16o{position:absolute;bottom:50%;transform:translateY(50%);right:0;min-width:100%;min-height:100%}@media screen and (max-width: 1024px){.hero__video.svelte-1iae16o{display:none}}@media screen and (max-width: 768px){.hero__video.svelte-1iae16o{display:none}}.hero__headings.svelte-1iae16o{text-transform:uppercase}.hero__headings--top.svelte-1iae16o{position:absolute;top:7.4rem;left:5.4rem}@media screen and (max-width: 1024px){.hero__headings--top.svelte-1iae16o{left:3.4rem}}.hero__headings--bottom.svelte-1iae16o{position:absolute;bottom:6rem;right:4rem;text-align:right;font-family:"REM Variable";text-shadow:0px 0.4rem 0.4rem rgba(0,0,0,0.25)}@media screen and (max-width: 1024px){.hero__headings--bottom.svelte-1iae16o{right:2rem}}.headings__background.svelte-1iae16o{background-color:#f36d21;border-radius:5px;padding:0 0.8rem 0 0.8rem}.headings__top.svelte-1iae16o{font-size:6.4rem;font-weight:800}@media screen and (max-width: 768px){.headings__top.svelte-1iae16o{font-size:5rem}}.headings__main.svelte-1iae16o{display:flex;font-size:7rem;font-weight:800}.headings__main--blue.svelte-1iae16o{color:#0e76bc}.headings__main--orange.svelte-1iae16o{color:#f36d21}@media screen and (max-width: 1024px){.headings__main.svelte-1iae16o{font-size:4rem}}@media screen and (max-width: 768px){.headings__main.svelte-1iae16o{font-size:3rem}}.headings__bottom.svelte-1iae16o{font-size:5.8rem;font-weight:800}@media screen and (max-width: 1024px){.headings__bottom.svelte-1iae16o{font-size:4rem}}@media screen and (max-width: 768px){.headings__bottom.svelte-1iae16o{font-size:3rem}}',
  map: null
};
const Hero = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$7);
  return `<div class="hero__container svelte-1iae16o" data-svelte-h="svelte-akx7ew"><div class="hero__video--container"><video class="hero__video svelte-1iae16o" autoplay loop muted><source${add_attribute("src", src, 0)} type="video/webm"></video></div> <div class="hero__headings svelte-1iae16o"><div class="hero__headings--top svelte-1iae16o"><h2 class="headings__top headings__background svelte-1iae16o">Learn to Fly</h2></div> <div class="hero__headings--bottom svelte-1iae16o"><h1 class="headings__main svelte-1iae16o"><span class="headings__main--blue svelte-1iae16o">First</span> <span class="headings__main--orange svelte-1iae16o">Landings</span> <span class="headings__main--blue svelte-1iae16o">Aviation</span></h1> <h2 class="headings__bottom svelte-1iae16o">Flight Training</h2></div></div> </div>`;
});
const FunPlane2 = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `<svg fill="none" height="100%" viewBox="0 0 331 340" width="100%" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_564_1638)"><path d="M176.926 281.815C177.568 278.911 177.03 275.813 175.337 273.307C173.702 270.887 171.216 269.26 168.337 268.724C165.46 268.188 162.534 268.808 160.099 270.471C159.4 270.948 158.756 271.503 158.186 272.121C155.924 274.574 154.923 277.816 155.32 280.978C154.914 281.337 154.526 281.716 154.159 282.113C149.195 287.495 148.567 295.452 152.631 301.465C153.908 303.354 155.573 304.913 157.501 306.057C156.798 308.628 156.85 311.361 157.659 313.892C157.57 313.981 157.484 314.072 157.398 314.165C154.189 317.644 153.782 322.787 156.409 326.673C157.911 328.894 160.192 330.388 162.834 330.879C165.475 331.371 168.161 330.802 170.395 329.276C171.037 328.838 171.627 328.329 172.151 327.761C173.486 326.314 174.353 324.513 174.689 322.617C175.965 322.212 177.185 321.619 178.314 320.848C179.186 320.254 179.988 319.562 180.699 318.791C183.053 316.239 184.325 312.942 184.365 309.584C185.341 309.218 186.277 308.731 187.154 308.133C187.981 307.569 188.743 306.911 189.419 306.178C189.419 306.178 189.419 306.178 189.419 306.178C193.553 301.696 194.077 295.068 190.692 290.061C188.016 286.101 183.516 284.057 178.946 284.462C178.81 284.235 178.667 284.011 178.518 283.792C178.043 283.089 177.511 282.428 176.926 281.815Z" fill="#0E76BC"></path><g clip-path="url(#clip1_564_1638)"><path d="M81.2058 89.9686C81.2031 89.9682 81.2016 89.9674 81.2016 89.9674C39.1317 89.9674 48.0136 89.9678 36.4215 89.9651C16.6531 89.9693 0.560176 106.062 0.552195 125.811C0.496712 145.632 16.552 161.668 36.3808 161.664C73.1154 161.664 52.4578 161.667 110.403 161.665L103.547 89.9872C103.545 89.9872 81.2073 89.967 81.2058 89.9686ZM72.203 143.744L54.3046 143.744L54.3339 107.89L72.2311 107.889L72.203 143.744Z" fill="#0E76BC"></path><path d="M294.698 89.9676C237.906 89.9672 256.624 89.9615 227.576 89.9866L220.719 161.664C285.009 161.667 273.399 161.661 294.74 161.666C314.296 161.666 330.618 145.88 330.57 125.827C330.562 106.054 314.473 89.9691 294.698 89.9676ZM276.817 143.743L258.919 143.743L258.891 107.888L276.788 107.89L276.817 143.743Z" fill="#0E76BC"></path><path d="M232.002 18.288L190.796 18.2865C187.086 7.87997 177.231 0.364568 165.562 0.361907C153.897 0.364947 144.041 7.87921 140.331 18.2865L99.1256 18.288C94.1757 18.288 90.1616 22.302 90.1654 27.2482C90.1654 32.1982 94.1772 36.2099 99.1256 36.2084L138.681 36.2069L138.681 45.2921C127.84 53.4835 120.77 66.4262 120.738 80.9969C120.736 81.2921 120.751 81.587 120.778 81.8777L132.887 208.47C115.296 214.658 102.836 231.58 102.836 250.765L102.839 268.687C102.839 273.637 106.85 277.648 111.799 277.647C115.765 277.647 219.327 277.647 219.329 277.647C224.279 277.647 228.289 273.638 228.289 268.687L228.292 250.764C228.293 231.58 215.835 214.653 198.241 208.468L210.35 81.8781C210.377 81.579 210.391 81.28 210.391 80.979C210.331 67.4477 204.355 54.2713 192.446 45.2632L192.446 36.2073L232.002 36.2088C236.952 36.2088 240.962 32.1993 240.962 27.2486C240.964 22.3001 236.952 18.288 232.002 18.288ZM137.791 259.727L120.759 259.727L120.756 250.764C120.755 240.807 126.347 231.874 134.682 227.237L137.791 259.727ZM210.371 250.765L210.369 259.727L193.337 259.727L196.444 227.237C204.777 231.873 210.369 240.807 210.371 250.765ZM174.524 98.9378L174.524 152.704C174.524 157.653 170.515 161.664 165.564 161.664C160.615 161.666 156.602 157.652 156.604 152.704L156.604 98.9378C156.604 93.9878 160.614 89.9776 165.564 89.9776C170.512 89.9753 174.526 93.9893 174.524 98.9378ZM174.526 27.2459L174.526 37.101C171.6 36.5044 168.596 36.1905 165.543 36.1917C162.482 36.1981 159.493 36.5162 156.602 37.1121L156.602 27.2455C156.6 22.3013 160.626 18.2831 165.562 18.2853C170.505 18.2857 174.524 22.3054 174.526 27.2459Z" fill="#0E76BC"></path></g><path d="M306.057 22.2813L266.941 22.2813C264.899 22.2857 262.941 23.1002 261.499 24.546C260.056 25.9917 259.246 27.9507 259.246 29.9931L259.246 38.958L230.5 60L259.246 56.8877L259.246 65.8525C259.251 67.8935 260.062 69.8499 261.504 71.2948C262.945 72.7396 264.9 73.5555 266.941 73.5644L278.903 73.5644L287.308 73.5644L294.937 73.5644L306.007 73.5644C308.048 73.5555 310.002 72.7396 311.444 71.2948C312.886 69.8499 313.697 67.8935 313.702 65.8525L313.702 29.9931C313.702 27.9594 312.899 26.0081 311.467 24.5637C310.035 23.1194 308.091 22.2991 306.057 22.2813Z" fill="#0E76BC"></path><path d="M298.869 38.448C298.869 36.1273 296.987 34.2461 294.667 34.2461C292.346 34.2461 290.465 36.1273 290.465 38.448V40.7261C290.465 43.0467 292.346 44.928 294.667 44.928C296.987 44.928 298.869 43.0467 298.869 40.7261V38.448Z" fill="white"></path><path d="M278.331 35.377C277.216 35.3858 276.15 35.8337 275.363 36.6234C274.577 37.4131 274.133 38.4811 274.129 39.5957V40.7263C274.129 43.0382 276.019 40.3213 278.331 40.3213C280.643 40.3213 282.533 43.0382 282.533 40.7263V39.5957C282.528 38.4811 282.085 37.4131 281.298 36.6234C280.512 35.8337 279.445 35.3858 278.331 35.377Z" fill="white"></path><path d="M272.004 50.4785C272.004 54.323 273.531 58.01 276.25 60.7285C278.968 63.4469 282.655 64.9741 286.5 64.9741C290.344 64.9741 294.031 63.4469 296.749 60.7285C299.468 58.01 300.995 54.323 300.995 50.4785L272.004 50.4785Z" fill="white"></path></g><defs><clipPath id="clip0_564_1638"><rect fill="white" height="340" width="331"></rect></clipPath><clipPath id="clip1_564_1638"><rect fill="white" height="275.154" transform="translate(-29 140.562) rotate(-45)" width="275.154"></rect></clipPath></defs></svg>`;
});
const PilotPlane = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `<svg fill="none" height="100%" viewBox="0 0 352 243" width="100%" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_386_2469)"><path d="M278.029 228.035C277.963 227.784 271.442 202.752 268.373 183.878C266.728 173.76 258.615 164.656 244.259 156.82C231.071 149.622 216.087 145.373 208.33 143.482C202.759 142.123 198.996 139.623 197.147 136.049C193.899 129.776 197.005 121.681 197.065 121.526C197.096 121.45 197.118 121.371 197.145 121.294C200.955 118.021 204.256 113.786 206.98 108.625C212.606 97.9663 214.899 85.1662 215.812 75.4072C221.138 72.9685 223.124 70.0877 224.077 67.5708C226.349 61.5655 222.339 55.8848 219.611 53.4754C219.288 53.1896 218.93 52.9522 218.548 52.7647L218.078 50.7777C225.73 49.2743 230.888 47.2744 232.891 42.9596C234.306 39.9142 233.812 36.4133 231.426 32.5531C228.191 27.3218 220.433 21.2172 211.18 16.6214C203.16 12.6375 190.287 7.88867 174.512 7.88867C146.716 7.88867 122.498 22.4948 117.371 32.9665C115.937 35.8939 115.889 38.9253 117.231 41.7323C119.795 47.0955 127.078 50.0459 131.339 51.3585L130.977 53.5094C130.446 53.9665 128.98 55.3012 127.683 57.1759C124.577 61.6671 124.932 65.4424 125.776 67.8188C126.883 70.9332 129.385 73.4539 133.43 75.4201C134.344 85.1748 136.632 97.925 142.228 108.56C144.957 113.747 148.268 118.002 152.092 121.288C152.146 121.448 152.207 121.606 152.279 121.763C152.313 121.838 155.7 129.365 152.787 135.47C150.992 139.23 146.98 141.93 140.86 143.494C131.244 145.951 117.218 150.272 105.012 156.9C90.6319 164.707 82.5087 173.784 80.8676 183.877C77.7992 202.751 71.2778 227.784 71.2121 228.034C70.5426 230.597 72.0768 233.217 74.6392 233.887C75.0459 233.994 75.4535 234.044 75.8554 234.044C76.3106 234.044 76.7556 233.975 77.1824 233.852H272.059C272.485 233.976 272.931 234.044 273.386 234.044C273.787 234.044 274.195 233.994 274.602 233.887C277.165 233.218 278.699 230.598 278.029 228.035ZM202.069 151.592L196.163 166.31L182.028 153.658L193.752 146.882C196.042 148.834 198.818 150.408 202.069 151.592ZM166.709 45.5652L170.8 48.9822L174.972 45.5944L179.144 48.9875L183.235 45.5656H198.212L192.304 49.5323H184.13L181.754 52.0333L188.641 52.0851L183.556 55.8795H178.025L174.972 58.9781L171.92 55.8795H166.389L161.303 52.0343L168.191 52.0462L165.815 49.5318H157.641L151.733 45.5652H166.709ZM136.16 61.8657H214.289C214.881 62.7098 215.308 63.6536 215.103 64.184C214.99 64.4751 211.901 71.3135 174.393 71.3135C137.671 71.3135 134.915 64.8847 134.815 64.6108C134.624 64.0847 135.291 62.8954 136.16 61.8657ZM143.427 78.5844C151.092 80.156 161.313 80.9051 174.393 80.9051C188.532 80.9051 198.609 79.9541 205.829 78.4722C204.795 86.6102 202.701 96.1832 198.497 104.149C192.925 114.704 185.115 119.835 174.621 119.835C164.108 119.835 156.289 114.686 150.716 104.095C146.551 96.1789 144.464 86.6879 143.427 78.5844ZM156.233 146.41L168.762 153.651L154.574 166.285L148.625 151.006C151.59 149.779 154.129 148.245 156.233 146.41ZM171.39 174.371L166.069 208.524L153.029 176.006C153.053 176.006 153.077 176.01 153.1 176.01C153.973 176.01 154.826 175.692 155.493 175.099L165.643 166.06L171.89 173.263C171.704 173.599 171.532 173.959 171.39 174.371ZM160.841 140.764C161.069 140.355 161.284 139.939 161.485 139.513C163.384 135.484 163.738 131.319 163.46 127.72C166.938 128.851 170.667 129.426 174.621 129.426C178.713 129.426 182.564 128.806 186.146 127.594C185.919 131.481 186.373 136.057 188.586 140.378C188.742 140.683 188.91 140.978 189.08 141.274L175.4 149.179L160.841 140.764ZM184.067 208.108L178.811 174.371C178.669 173.959 178.496 173.599 178.312 173.263L184.795 165.788L195.191 175.093C195.619 175.475 196.124 175.743 196.662 175.886L184.067 208.108ZM237.916 211.223H230.326L228.118 213.463L234.514 213.43L229.792 216.978H224.656L221.821 219.856L218.987 216.978H213.85L209.128 213.43L215.524 213.463L213.317 211.223H205.726L200.24 207.386H214.148L217.947 210.546L221.821 207.386L225.695 210.546L229.495 207.386H243.402L237.916 211.223Z" fill="#0E76BC"></path><path d="M218.25 131.372C216.297 133.325 216.297 136.49 218.25 138.443C220.203 140.396 223.369 140.396 225.321 138.443L218.25 131.372ZM248.75 100.872L218.25 131.372L225.321 138.443L255.821 107.943L248.75 100.872Z" fill="#0E76BC"></path><path d="M245.091 127.214C243.139 129.167 243.139 132.333 245.091 134.285C247.044 136.238 250.21 136.238 252.162 134.285L245.091 127.214ZM260.091 112.214L245.091 127.214L252.162 134.285L267.162 119.285L260.091 112.214Z" fill="#0E76BC"></path><path d="M222.464 104.587C220.512 106.539 220.512 109.705 222.464 111.658C224.417 113.61 227.583 113.61 229.536 111.658L222.464 104.587ZM237.464 89.5865L222.464 104.587L229.536 111.658L244.536 96.6576L237.464 89.5865Z" fill="#0E76BC"></path><g clip-path="url(#clip1_386_2469)"><path d="M336.425 93.3577C337.109 92.6697 337.589 91.8058 337.812 90.8617C338.035 89.9177 337.992 88.9303 337.688 88.0091L326.322 53.9118L341.179 39.0546C344.213 36.0205 345.918 31.9054 345.918 27.6146C345.918 23.3237 344.213 19.2086 341.179 16.1745C338.145 13.1404 334.03 11.4359 329.739 11.4359C325.449 11.4359 321.333 13.1404 318.299 16.1745L303.442 31.0317L269.345 19.666C268.424 19.3621 267.436 19.3192 266.492 19.5421C265.548 19.765 264.684 20.245 263.996 20.9288L251.628 33.2974C251.017 33.8975 250.563 34.6375 250.304 35.4532C250.045 36.2688 249.99 37.1354 250.142 37.9775C250.298 38.8106 250.652 39.5936 251.176 40.2598C251.7 40.926 252.378 41.4555 253.15 41.8032L280.339 54.1347L266.485 67.989L257.496 63.4576C256.509 62.969 255.394 62.803 254.307 62.9829C253.221 63.1629 252.219 63.6797 251.442 64.4604L242.342 73.5605C241.852 74.0539 241.466 74.6396 241.204 75.2836C240.943 75.9275 240.812 76.617 240.819 77.3119C240.825 78.6899 241.372 80.0106 242.342 80.9891L276.402 115.049C277.387 116.034 278.723 116.588 280.116 116.588C281.509 116.588 282.846 116.034 283.831 115.049L293.116 105.763C293.897 104.987 294.414 103.984 294.594 102.898C294.774 101.812 294.608 100.696 294.119 99.7091L289.365 90.8691L303.182 77.0519L315.514 104.241C315.861 105.014 316.391 105.691 317.057 106.215C317.723 106.739 318.506 107.094 319.339 107.249C320.181 107.401 321.048 107.346 321.864 107.087C322.679 106.828 323.419 106.374 324.019 105.763L336.425 93.3577ZM309.645 65.8347C309.299 65.0503 308.765 64.3626 308.092 63.8317C307.419 63.3008 306.626 62.9428 305.782 62.789C304.949 62.6383 304.091 62.6913 303.283 62.9436C302.475 63.1958 301.739 63.6397 301.139 64.2376L279.448 85.9291C278.665 86.7129 278.15 87.7241 277.977 88.8182C277.803 89.9122 277.98 91.0331 278.482 92.0206L282.976 100.972L280.079 103.869L253.448 77.2376L256.345 74.3405L265.296 78.8348C266.284 79.3366 267.405 79.5135 268.499 79.3401C269.593 79.1666 270.604 78.6517 271.388 77.8691L293.079 56.1775C293.677 55.5777 294.121 54.8423 294.373 54.0339C294.625 53.2254 294.678 52.368 294.528 51.5347C294.374 50.6911 294.016 49.898 293.485 49.2247C292.954 48.5513 292.266 48.0182 291.482 47.6718L264.331 35.3775L269.085 30.6232L303.145 41.9518C304.068 42.2677 305.061 42.3204 306.012 42.104C306.963 41.8875 307.835 41.4103 308.531 40.726L325.579 23.6774C326.643 22.6135 328.086 22.0158 329.591 22.0158C331.095 22.0158 332.538 22.6135 333.602 23.6774C334.666 24.7413 335.264 26.1843 335.264 27.6889C335.264 29.1934 334.666 30.6364 333.602 31.7003L316.554 48.7489C315.869 49.4443 315.392 50.3164 315.176 51.2677C314.959 52.2189 315.012 53.2117 315.328 54.1347L326.656 88.1948L321.939 92.912L309.645 65.8347Z" fill="#0E76BC"></path></g></g><defs><clipPath id="clip0_386_2469"><rect fill="white" height="243" width="352"></rect></clipPath><clipPath id="clip1_386_2469"><rect fill="white" height="126.068" transform="translate(300.21 -32) rotate(45)" width="126.068"></rect></clipPath></defs></svg>`;
});
const GlobePlane = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `<svg fill="none" height="100%" viewBox="0 0 350 240" width="100%" xmlns="http://www.w3.org/2000/svg"><path d="M175.296 0C108.842 0 55 53.7375 55 120C55 186.262 108.847 240 175.296 240C241.745 240 295.536 186.262 295.536 120C295.536 53.7375 241.703 0 175.296 0ZM162.876 38.3063H168.722V31.3734H163.586V13.5281H170.902V4.39219L171.321 3.43125C172.613 3.37031 173.933 3.3 175.296 3.3C181.045 3.30129 186.786 3.73219 192.471 4.58906V10.5891H200.873V33.3844H194.478L188.956 38.85L175.653 52.1859L168.717 59.1047L162.872 53.2687L162.876 38.3063ZM140.415 8.62969L142.576 10.7719L138.728 14.6109H132.149V21.1734H146.016V51.4406H135.429V29.5312H128.103V18.9797H123.367V25.1766L118.799 29.7375H107.991L105.012 26.7656C115.677 18.7293 127.654 12.5936 140.415 8.62969ZM178.585 177.975H168.717L163.586 185.292V201.698L148.591 212.648V232.336L131.764 217.031V176.864L113.842 160.102V139.688L101.441 130.58H90.4591L82.5976 122.719V111.975L77.3253 108.694L75.8216 112.688L78.4013 114.145V123.281L71.8226 115.266L68.5333 102.473L65.587 101.737V79.4672C71.3967 63.9001 80.4744 49.7513 92.2119 37.9688L128.822 38.3063L127.413 45.975L116.436 46.6828L117.526 50.3297L120.101 53.2641L117.155 57.9844L108.395 56.925L113.522 63.8578L122.262 70.0312L125.204 76.9641L128.836 75.8813V57.9844H138.742V60.2109H148.953V72.5953H144.569V77.7H140.185V80.9812H146.392L142.374 84.9891L140.72 83.3531L136.858 87.1547V90.4359L133.409 93.8906L129.034 98.2734L123.907 103.416L120.453 106.875V117.816H115.656V111.975H99.9747V118.57L115.331 133.158H146.016V136.069H157.007L169.079 151.364H178.585V177.975ZM271.801 110.133V119.653H256.092L248.39 111.975V106.875H243.841V114L254.254 124.364H266.143V132.947L255.335 143.695V173.977H247.126V189.478L240.726 195.844H225.689V182.062L217.559 173.977V148.594L207.452 138.52H186.306L178.012 130.242V109.219L185.159 102.155H197.189L204.872 94.4719H214.03V98.4937H242.159V93.5719H235.078L239.264 89.3859L243.306 85.3781H250.209L245.843 81.0234H239.311L232.408 87.9328V93.2812L225.031 85.9031H220.445L227.183 92.6531H221.713L217.32 88.2703V85.3312L210.741 78.7687L205.812 83.7047L201.606 87.9234V95.5547H193.185V80.2594H196.287V77.5031L198.293 75.4922L194.67 71.8594L189.891 76.6031L186.043 72.7641L188.092 70.7531V59.8266H195.76V64.2188L202.302 70.7812H207.104V65.6484H221.713V60.5484H227.554V53.2641H221.352V46.3359H218.062V60.2109L215.492 62.7516L210.37 60.5484L201.606 58.3687L202.302 50.0156L211.117 43.4203L216.211 34.6875L225.731 32.4844L224.641 36.8672L230.844 37.9359L230.496 42.3281L237.432 41.6063L240.721 39.4172L241.44 35.7844H256.092C267.518 46.6502 276.613 59.7169 282.827 74.1929C289.041 88.6689 292.244 104.253 292.242 120C292.242 121.795 292.199 123.539 292.11 125.32L266.665 99.9516L264.108 102.492L271.801 110.133Z" fill="#0E76BC"></path><path d="M125.606 122.157C125.366 122.158 125.01 122.2 124.822 122.239C124.502 122.31 121.72 123.831 121.722 123.942C121.719 123.965 127.324 128.541 134.167 134.11L146.627 144.233L149.137 147.511C150.519 149.312 151.639 150.795 151.621 150.809C151.603 150.822 149.723 150.941 147.45 151.081C145.178 151.213 142.383 151.383 141.242 151.452C140.094 151.521 139.123 151.572 139.068 151.565C139.013 151.558 137.549 149.589 135.804 147.189C133.87 144.521 132.464 142.662 132.2 142.415C131.665 141.922 130.631 141.207 130.278 141.099C130.011 141.01 127.603 141.078 127.496 141.167C127.469 141.196 127.385 142.93 127.302 145.029C127.228 147.128 127.148 148.895 127.131 148.964C127.098 149.102 127.135 149.122 120.974 145.219C119.026 143.986 117.229 142.883 116.981 142.765C115.965 142.289 114.39 142.328 113.727 142.845C113.541 142.987 113.383 143.165 113.373 143.25C113.361 143.343 114.898 145.243 117.792 148.696C120.23 151.601 122.33 154.093 122.448 154.226L122.673 154.468L122.335 154.678C121.902 154.955 121.642 155.372 121.571 155.932C121.521 156.328 121.537 156.394 121.726 156.599C122.085 156.976 123.18 157.39 124.503 157.644L124.813 157.707L126.853 161.241C127.97 163.183 128.963 164.848 129.048 164.93C129.273 165.171 130.287 165.283 130.895 165.138C131.781 164.934 131.752 164.978 132.719 162.375C133.19 161.108 133.585 160.067 133.595 160.053C133.611 160.047 134.366 160.19 135.284 160.368C138.03 160.904 141.251 161.396 145.597 161.944C150.987 162.623 153.297 162.819 157.448 162.955C158.401 162.988 159.264 163.034 159.371 163.063C159.511 163.096 160.472 164.126 162.285 166.179L164.989 169.244L164.066 176.607C163.552 180.665 163.149 183.978 163.165 183.98C163.18 183.982 163.989 184.013 164.957 184.048C166.869 184.115 167.33 184.063 167.989 183.711C168.202 183.596 168.54 183.323 168.727 183.101C169.137 182.632 168.828 183.122 175.994 171.657C181.029 163.604 181.792 162.428 181.963 162.402C182.076 162.385 182.635 162.377 183.201 162.377C185.592 162.378 190.07 162.136 193.593 161.822C204.695 160.812 211.617 158.833 213.405 156.16C213.761 155.62 213.796 155.53 213.875 154.908C213.949 154.317 213.942 154.19 213.765 153.694C213.403 152.653 212.674 152.111 210.257 151.064C208.224 150.184 208.059 150.1 206.768 149.282C205.477 148.464 205.036 148.29 203.512 147.995C201.225 147.549 199.388 147.641 196.573 148.345C195.964 148.497 195.389 148.63 195.299 148.651C195.209 148.671 194.38 148.732 193.449 148.789C192.525 148.846 190.533 148.966 189.032 149.053C180.551 149.557 178.151 149.697 178.009 149.679C177.923 149.668 175.644 148.473 172.942 147.019C155.293 137.537 140.464 129.572 130.307 124.115C126.538 122.092 126.637 122.129 125.606 122.157Z" fill="#F36D21"></path><path d="M126 156C-63.3306 153.718 8.67655 134.752 53.9622 120" stroke="#F36D21" stroke-dasharray="4 4" stroke-width="3"></path></svg>`;
});
const css$6 = {
  code: ".funnel.svelte-cn9rcp{display:grid;grid-template-columns:1fr 1fr 1fr;gap:2.5rem;padding:10rem 5rem}@media screen and (max-width: 1280px){.funnel.svelte-cn9rcp{display:flex;flex-direction:column}}@media screen and (max-width: 1024px){.funnel.svelte-cn9rcp{gap:2rem;padding:5rem 2rem}}",
  map: null
};
const Funnel = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$6);
  return `<article class="funnel svelte-cn9rcp">${validate_component(FunnelCard, "FunnelCard").$$render(
    $$result,
    {
      button: "Private Pilot",
      href: "/services/private-pilot",
      icon: true
    },
    {},
    {
      icon: () => {
        return `<div slot="icon"${add_styles({ "height": `inherit` })}>${validate_component(FunPlane2, "FlyForFun").$$render($$result, {}, {}, {})}</div>`;
      },
      main: () => {
        return `<div slot="main" data-svelte-h="svelte-lbo54d">Whether you have dreamed of becoming a pilot your entire life or have just
            recently found a passion for aviation, First Landings can help you get
            started.
            <br> <br>
            We can provide you with a detailed overview of the opportunities available
            to you as a Private Pilot or Sport Pilot and we&#39;ll assist in connecting you
            to the necessary tools and training to help you achieve your dream. We also
            offer accelerated courses as well, allowing you to go at your own pace.</div>`;
      },
      title: () => {
        return `<div slot="title" data-svelte-h="svelte-mtk1ab">Learn to fly for fun</div>`;
      }
    }
  )} ${validate_component(FunnelCard, "FunnelCard").$$render(
    $$result,
    {
      button: "Professional Pilot",
      href: "/services/professional-pilot-program",
      icon: true
    },
    {},
    {
      icon: () => {
        return `<div slot="icon"${add_styles({ "height": `inherit` })}>${validate_component(PilotPlane, "PilotPlane").$$render($$result, {}, {}, {})}</div>`;
      },
      main: () => {
        return `<div slot="main" data-svelte-h="svelte-1d7uyf">The Career Pilot course is the quickest and most cost-effective way to
            begin your pilot career. Enrolling in a comprehensive program and
            successfully completing the necessary flight training is crucial to
            initiating your journey toward an airline pilot career.
            <br> <br>
            At First Landings Aviation, our Airline Career Training (ACT) program offers
            a clear and distinct path to become a Commercial Airline Pilot and our pilot
            career centre is available at your disposal to help you plot your path to the
            airlines. New-hire pilot jobs are offering $60,000 or more, what are you waiting
            for?</div>`;
      },
      title: () => {
        return `<div slot="title" data-svelte-h="svelte-zejw4v">Career pilot training</div>`;
      }
    }
  )} ${validate_component(FunnelCard, "FunnelCard").$$render(
    $$result,
    {
      button: "International students",
      href: "/services/international-students",
      icon: true
    },
    {},
    {
      icon: () => {
        return `<div slot="icon"${add_styles({ "height": `inherit` })}>${validate_component(GlobePlane, "GlobePlane").$$render($$result, {}, {}, {})}</div>`;
      },
      main: () => {
        return `<div slot="main" data-svelte-h="svelte-1c3gt6u">First Landings Aviation &amp; Pilots is an approved FAA Certified Part 141
            school and able to issue M-1 Visa’s through the Student and Exchange Visa
            Information Service (SEVIS) program.
            <br> <br>
            We understand that every country has unique aircraft requirements, so First
            Landings has partnered with other service providers, allowing us to equip you
            with your optimal country equivalent testing requirements.</div>`;
      },
      title: () => {
        return `<div slot="title" data-svelte-h="svelte-ty9qhj">International students</div>`;
      }
    }
  )} </article>`;
});
const css$5 = {
  code: ".AviationExperience__figure.svelte-1qvl0im{position:relative;height:100vh;padding:5rem 1rem;display:flex;flex-direction:column;overflow:hidden}.AviationExperience__img.svelte-1qvl0im{height:100%;width:100%;position:absolute;top:50%;left:50%;transform:translate(-50%, -50%);z-index:-1;object-fit:cover}.AviationExperience__top.svelte-1qvl0im,.AviationExperience__bottom.svelte-1qvl0im{display:flex;flex-direction:column;justify-content:center;align-items:center;gap:1rem}.AviationExperience__bottom.svelte-1qvl0im{margin-top:auto}.AviationExperience__h2.svelte-1qvl0im{background-color:#f36d21;border-radius:0.5rem;padding:1.4rem;font-size:5rem;font-weight:800;text-transform:uppercase;text-align:center}@media(max-width: 1024px){.AviationExperience__h2.svelte-1qvl0im{font-size:3.5rem}}.AviationExperience__paragraph.svelte-1qvl0im{max-width:90rem}.AviationExperience__paragraph--text.svelte-1qvl0im{font-size:2.4rem;text-align:center;margin:0;line-height:normal}@media(max-width: 1024px){.AviationExperience__paragraph--text.svelte-1qvl0im{font-size:1.8rem}}.AviationExperience__h3.svelte-1qvl0im{background-color:#0e76bc;border-radius:0.5rem;padding:0.8rem;font-size:3.8rem;font-weight:600;text-align:center;text-transform:uppercase}@media(max-width: 768px){.AviationExperience__h3.svelte-1qvl0im{font-size:3rem}}",
  map: null
};
const AviationExperience = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$5);
  return `<article class="AviationExperience" data-svelte-h="svelte-z1o16w"><figure class="AviationExperience__figure svelte-1qvl0im"><picture><source${add_attribute("srcset", "/_app/immutable/assets/flying_next_to_clouds.c8d66be6.avif 540w, /_app/immutable/assets/flying_next_to_clouds.440ce15f.avif 768w, /_app/immutable/assets/flying_next_to_clouds.3be83d45.avif 1080w, /_app/immutable/assets/flying_next_to_clouds.cbf0b6d9.avif 1366w, /_app/immutable/assets/flying_next_to_clouds.1a1ad98d.avif 1536w, /_app/immutable/assets/flying_next_to_clouds.6c5a583a.avif 1920w, /_app/immutable/assets/flying_next_to_clouds.21b8207a.avif 2560w, /_app/immutable/assets/flying_next_to_clouds.b7c4eb29.avif 3000w, /_app/immutable/assets/flying_next_to_clouds.7670245a.avif 4096w", 0)} sizes="100vw" type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/flying_next_to_clouds.3402d658.webp 540w, /_app/immutable/assets/flying_next_to_clouds.0d462cc1.webp 768w, /_app/immutable/assets/flying_next_to_clouds.07c40f51.webp 1080w, /_app/immutable/assets/flying_next_to_clouds.1cbebc53.webp 1366w, /_app/immutable/assets/flying_next_to_clouds.0124e374.webp 1536w, /_app/immutable/assets/flying_next_to_clouds.041973ca.webp 1920w, /_app/immutable/assets/flying_next_to_clouds.52c71d76.webp 2560w, /_app/immutable/assets/flying_next_to_clouds.d0a9472b.webp 3000w, /_app/immutable/assets/flying_next_to_clouds.0752c4a2.webp 4096w", 0)} sizes="100vw" type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/flying_next_to_clouds.881a0856.png 540w, /_app/immutable/assets/flying_next_to_clouds.5df8ddb2.png 768w, /_app/immutable/assets/flying_next_to_clouds.17c2a1ce.png 1080w, /_app/immutable/assets/flying_next_to_clouds.7d97f033.png 1366w, /_app/immutable/assets/flying_next_to_clouds.43b93c3e.png 1536w, /_app/immutable/assets/flying_next_to_clouds.46f0ac2e.png 1920w, /_app/immutable/assets/flying_next_to_clouds.712359b4.png 2560w, /_app/immutable/assets/flying_next_to_clouds.d053e85b.png 3000w, /_app/immutable/assets/flying_next_to_clouds.dce61918.png 4096w", 0)} sizes="100vw" type="image/png"><img class="AviationExperience__img svelte-1qvl0im" alt="Pilot flying next to clouds" src="/_app/immutable/assets/flying_next_to_clouds.dce61918.png" width="4096" height="2732"></picture> <section class="AviationExperience__top svelte-1qvl0im"><h2 class="AviationExperience__h2 svelte-1qvl0im">Kick start your aviation experience</h2> <div class="AviationExperience__paragraph svelte-1qvl0im"><p class="AviationExperience__paragraph--text svelte-1qvl0im">The human obsession with flight stems from a refusal to accept limitations and
                    an intense desire to find out which of your neighbors secretly have pools.</p></div></section> <section class="AviationExperience__bottom svelte-1qvl0im"><h3 class="AviationExperience__h3 svelte-1qvl0im">Take your discovery flight today!</h3> <div class="AviationExperience__paragraph svelte-1qvl0im"><p class="AviationExperience__paragraph--text svelte-1qvl0im">First Landings offers career opportunities for those wanting to become an
                    airline pilot with in-house development programs.</p></div></section></figure> </article>`;
});
const css$4 = {
  code: ".programs__card.svelte-1pp6ywi{grid-area:one;display:flex;flex-direction:column;gap:5rem;padding:2.5rem;background-color:#0e76bc;border-radius:4rem;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1)}.programs__card--programs.svelte-1pp6ywi{display:flex;flex-direction:column;gap:1rem}.programs__card--headings.svelte-1pp6ywi{display:flex;flex-direction:column;gap:2.5rem}.headings__title.svelte-1pp6ywi{width:fit-content;margin:0 auto;font-family:'REM Variable', Inter, sans-serif;font-size:3rem;line-height:normal;text-transform:uppercase;text-align:center}.headings__description.svelte-1pp6ywi{width:100%;margin:0;padding:0;font-size:1.8rem;font-weight:400;line-height:normal;text-align:center}.seperator.svelte-1pp6ywi{border:0.1px solid rgba(255,255,255,0.5);margin:0}.program.svelte-1pp6ywi{display:flex;flex-direction:column;align-items:flex-end;gap:1rem}.program__bar.svelte-1pp6ywi{width:100%;display:flex;justify-content:space-between;align-items:center;gap:1rem;border:0.2rem solid #fff;border-radius:4rem;font-size:1.6rem;font-weight:600}.program__bar--name.svelte-1pp6ywi{height:100%;min-width:fit-content;padding:1.5rem;color:#0e76bc;background-color:#fff;border-radius:4rem}.program__bar--duration.svelte-1pp6ywi{padding-right:1.5rem}.one.svelte-1pp6ywi{width:25%}.two.svelte-1pp6ywi{width:50%}.three.svelte-1pp6ywi{width:75%}.four.svelte-1pp6ywi{color:#0e76bc;background-color:#fff}",
  map: null
};
const CompoundCard = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$4);
  return `<section class="programs__card svelte-1pp6ywi"><div class="programs__card--headings svelte-1pp6ywi" data-svelte-h="svelte-1j832ti"><h2 class="headings__title svelte-1pp6ywi">Accelerated programs
			<hr class="seperator svelte-1pp6ywi"></h2> <p class="headings__description svelte-1pp6ywi">Our Accelerated Program is an intensive course that gets you prepared to pass the FAA
			checkride. First Landings Aviation prepares you to become a safe and competent pilot
			through our advanced training techniques. All our efforts and yours will concentrate on
			training you to be a safe, responsible, and experienced pilot.</p></div> <div class="programs__card--programs svelte-1pp6ywi"> <div class="program svelte-1pp6ywi"><div class="program__bar svelte-1pp6ywi" data-svelte-h="svelte-1m5pbhh"><span class="program__bar--name three svelte-1pp6ywi">Private</span> <span class="program__bar--duration svelte-1pp6ywi">3 Weeks</span></div> <div class="program__button">${validate_component(Button, "Button").$$render(
    $$result,
    {
      href: "/services/accelerated-training#private"
    },
    {},
    {
      default: () => {
        return `Private pilot accelerated`;
      }
    }
  )}</div></div> <div class="program svelte-1pp6ywi"><div class="program__bar svelte-1pp6ywi" data-svelte-h="svelte-10nf2uo"><span class="program__bar--name two svelte-1pp6ywi">Instrument</span> <span class="program__bar--duration svelte-1pp6ywi">2 Weeks</span></div> <div class="program__button">${validate_component(Button, "Button").$$render(
    $$result,
    {
      href: "/services/accelerated-training#instrument"
    },
    {},
    {
      default: () => {
        return `Instrument rating accelerated`;
      }
    }
  )}</div></div> <div class="program svelte-1pp6ywi"><div class="program__bar four svelte-1pp6ywi" data-svelte-h="svelte-ozmu8l"><span class="program__bar--name svelte-1pp6ywi">Commercial</span> <span class="program__bar--duration svelte-1pp6ywi">20 Weeks</span></div> <div class="program__button">${validate_component(Button, "Button").$$render(
    $$result,
    {
      href: "/services/accelerated-training#career"
    },
    {},
    {
      default: () => {
        return `Commercial pilot accelerated`;
      }
    }
  )}</div></div> <div class="program svelte-1pp6ywi"><div class="program__bar svelte-1pp6ywi" data-svelte-h="svelte-rtlumi"><span class="program__bar--name one svelte-1pp6ywi">Multi-Engine</span> <span class="program__bar--duration svelte-1pp6ywi">5 Days</span></div> <div class="program__button">${validate_component(Button, "Button").$$render(
    $$result,
    {
      href: "/services/accelerated-training#career"
    },
    {},
    {
      default: () => {
        return `Multi-engine rating accelerated`;
      }
    }
  )}</div></div></div> </section>`;
});
const css$3 = {
  code: ".program__card.svelte-2w5u5y{display:flex;flex-direction:column;align-items:center;gap:2.5rem;padding:2.5rem;background-color:#f36d21;border-radius:4rem;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1);text-align:center;line-height:normal}.program__card--title.svelte-2w5u5y{width:fit-content;font-family:'REM Variable', Inter, sans-serif;font-size:3rem;text-transform:uppercase}.program__card--sub.svelte-2w5u5y{margin:0;padding:0;font-size:2rem;font-weight:600}.program__card--p.svelte-2w5u5y{width:100%;margin:0;padding:0;font-size:1.8rem;font-weight:400}.program__card--button.svelte-2w5u5y{margin-top:auto}.seperator.svelte-2w5u5y{border:0.1px solid rgba(255,255,255,0.5);margin:0}",
  map: null
};
const ProgramCard = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { href } = $$props;
  if ($$props.href === void 0 && $$bindings.href && href !== void 0)
    $$bindings.href(href);
  $$result.css.add(css$3);
  return `<section class="program__card svelte-2w5u5y"><h2 class="program__card--title svelte-2w5u5y">${slots.title ? slots.title({}) : ``} <hr class="seperator svelte-2w5u5y"></h2> <h3 class="program__card--sub svelte-2w5u5y">${slots.subTitle ? slots.subTitle({}) : ``}</h3> <p class="program__card--p svelte-2w5u5y">${slots.main ? slots.main({}) : ``}</p> <div class="program__card--button svelte-2w5u5y">${validate_component(Button, "Button").$$render($$result, { href, size: "large" }, {}, {
    default: () => {
      return `${slots.button ? slots.button({}) : ``}`;
    }
  })}</div> </section>`;
});
const css$2 = {
  code: '.programs.svelte-8veqaq{display:grid;grid-template-areas:"one two" "one three" "four five";gap:2.5rem;padding:10rem 5rem}@media screen and (max-width: 1280px){.programs.svelte-8veqaq{display:flex;flex-direction:column}}@media screen and (max-width: 1024px){.programs.svelte-8veqaq{gap:2rem;padding:5rem 2rem}}',
  map: null
};
const MainPrograms = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$2);
  return `<article class="programs svelte-8veqaq">${validate_component(CompoundCard, "CompoundCard").$$render($$result, {}, {}, {})} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, { href: "/services/private-pilot" }, {}, {
    button: () => {
      return `<div slot="button" data-svelte-h="svelte-6ko0fs">Private pilot</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-1rnfrm4">Private pilot training is the first step towards a career in aviation and allows you to
			fly anywhere in the world, fly just about any aircraft, carry multiple passengers, and
			fly at night and in more types of airspace with no distance restrictions. If you’re a
			Sport Pilot looking to transition to a Private, we can make the transition easy and
			affordable.</div>`;
    },
    subTitle: () => {
      return `<div slot="subTitle" data-svelte-h="svelte-f1d9p6">The Private Pilot License is the most popular pilot certificate</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-15typy7">Private pilot license</div>`;
    }
  })} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, { href: "/services/instrument-rating" }, {}, {
    button: () => {
      return `<div slot="button" data-svelte-h="svelte-18vnfun">Instrument rating</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-b1svyd">Expand your capabilities with IFR training to become a more skilled and proficient
			pilot. Fly through the clouds and in other more demanding conditions safely. An
			Instrument Rating is usually the next step people take after getting a Private Pilot
			license, getting them one step closer to the dream career in aviation.</div>`;
    },
    subTitle: () => {
      return `<div slot="subTitle" data-svelte-h="svelte-d9jk56">Earning an Instrument Rating will allow you to fly under Instrument Flight Rules (IFR)
			conditions</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-1uv3686">Instrument rating add-on</div>`;
    }
  })} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, { href: "/services/commercial-pilot" }, {}, {
    button: () => {
      return `<div slot="button" data-svelte-h="svelte-7vfcjf">Commercial pilot</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-e2bd13">The training process of this certificate guides the pilot back to the fundamentals of
			airmanship, steering away from the demanding aspects of instrument training. This
			license allows you to earn a living by taking on a multitude of pilot jobs including
			transporting passengers on flights spanning across the country or around the world. We
			customize our program to help you earn your Commercial Pilot Certificate.</div>`;
    },
    subTitle: () => {
      return `<div slot="subTitle" data-svelte-h="svelte-572shp">A Commercial Pilot License opens up an exciting journey towards a rewarding career in
			aviation</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-1vd3emk">Commercial pilot license</div>`;
    }
  })} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, { href: "/services/multi-engine-rating" }, {}, {
    button: () => {
      return `<div slot="button" data-svelte-h="svelte-1143ve5">Multi-engine</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-1mgopwi">Dozens of students complete our multi-engine program every single month. If you need to
			get your multi add-on as quickly and efficiently as possible, this is the program for
			you.</div>`;
    },
    subTitle: () => {
      return `<div slot="subTitle" data-svelte-h="svelte-1mkpz9i">Fly airplanes with more than one engine. Twice the engines, twice the fun</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-167vu52">Multi engine rating add-on</div>`;
    }
  })} </article>`;
});
const css$1 = {
  code: ".CareerMission.svelte-e9rd10.svelte-e9rd10{position:relative;height:100vh;overflow:hidden;width:100%}.CareerMission__img.svelte-e9rd10.svelte-e9rd10{position:absolute;height:100%;width:100%;object-fit:cover;top:50%;left:50%;transform:translate(-50%, -50%);z-index:-1}.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{color:#0e76bc;font-size:8rem;font-weight:800;text-transform:uppercase;display:flex;flex-direction:column;align-items:flex-start;font-family:'REM Variable';padding:10rem 5rem}@media screen and (max-width: 1536px){.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{font-size:6.5rem}}@media screen and (max-width: 1280px){.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{font-size:5.5rem;padding-top:5rem}}@media screen and (max-width: 768px){.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{align-items:center}}@media screen and (max-width: 640px){.CareerMission__h2.svelte-e9rd10.svelte-e9rd10{font-size:4.5rem;padding:0;align-items:center;padding-top:10rem}}.CareerMission__h2.svelte-e9rd10 span.svelte-e9rd10{color:#fff}",
  map: null
};
const CareerMission = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$1);
  return `<article class="CareerMission svelte-e9rd10" data-svelte-h="svelte-8xpucr"><figure class="CareerMission__figure"><picture><source${add_attribute("srcset", "/_app/immutable/assets/aj.c2e673ec.avif 1x, /_app/immutable/assets/aj.3ba2f018.avif 2x", 0)} type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/aj.362bdd83.webp 1x, /_app/immutable/assets/aj.4cdd39bb.webp 2x", 0)} type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/aj.f2b7b86b.png 1x, /_app/immutable/assets/aj.532f49dc.png 2x", 0)} type="image/png"><img class="CareerMission__img svelte-e9rd10" alt="The GOAT" size="100vw" src="/_app/immutable/assets/aj.532f49dc.png" width="4032" height="3025"></picture> <h2 class="CareerMission__h2 svelte-e9rd10">Your Career <span class="svelte-e9rd10">Our Mission</span></h2></figure> </article>`;
});
const css = {
  code: ".programs.svelte-2nuvz1{display:grid;grid-template-columns:1fr 1fr;gap:2.5rem;padding:10rem 5rem}@media screen and (max-width: 1280px){.programs.svelte-2nuvz1{display:flex;flex-direction:column}}@media screen and (max-width: 1024px){.programs.svelte-2nuvz1{gap:2rem;padding:5rem 2rem}}",
  map: null
};
const SpecialPrograms = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css);
  return `<article class="programs svelte-2nuvz1">${validate_component(ProgramCard, "ProgramCard").$$render($$result, { href: "/services/flight-instructor" }, {}, {
    button: () => {
      return `<div slot="button" data-svelte-h="svelte-bv8fnk">Flight instructor</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-1vfaqzn">The CFI flight training will allow you to teach private and commercial applicants.
			Obtaining your flight instructor certificate is an exciting opportunity and it’s well
			worth the effort.</div>`;
    },
    subTitle: () => {
      return `<div slot="subTitle" data-svelte-h="svelte-1e0ppko">Become a Certified Flight Instructor (CFI)</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-xq4sh1">Certified flight instructor</div>`;
    }
  })} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, { href: "/services/flight-instructor" }, {}, {
    button: () => {
      return `<div slot="button" data-svelte-h="svelte-mhmmtt">Flight instructor instrument</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-13muydn">CFII or Certified Flight Instructor Instrument allows you to teach instrument rating
			applicants; both on ground (aeronautical knowledge) and flight training.</div>`;
    },
    subTitle: () => {
      return `<div slot="subTitle" data-svelte-h="svelte-1432ift">Add instrument training capabilities to your instructing skills</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-4ihybv">Certified flight instructor - instrument</div>`;
    }
  })} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, { href: "/services/flight-instructor" }, {}, {
    button: () => {
      return `<div slot="button" data-svelte-h="svelte-1qhs8pd">Flight instructor multi</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-1j3k6si">Adding a Multi-Engine Rating to your Flight Instructor Certificate will allow you to
			teach in a larger variety of aircraft and provide training for pilots seeking to start a
			career in aviation.</div>`;
    },
    subTitle: () => {
      return `<div slot="subTitle" data-svelte-h="svelte-o4cph8">Expand your instruction to include twin engines and more</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-126hp5u">Certified multi engine instructor</div>`;
    }
  })} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, { href: "/contact-us" }, {}, {
    button: () => {
      return `<div slot="button" data-svelte-h="svelte-1aw7scr">Contact us</div>`;
    },
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-v6gawm">Prepare for the real world of flying by acting as a commercial pilot while in training.
			Throughout the syllabus, the time building pilot will take on different tasks or jobs
			designed to improve critical thinking and flight management skills.</div>`;
    },
    subTitle: () => {
      return `<div slot="subTitle" data-svelte-h="svelte-1d7x39m">Use real-world scenarios to enhance development of pilot decision-making skills</div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-4rqxdo">Time building program</div>`;
    }
  })} </article>`;
});
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `${$$result.head += `<!-- HEAD_svelte-13bulhc_START -->${$$result.title = `<title>Home | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation flight instruction and airplane rental for aspiring pilots"><!-- HEAD_svelte-13bulhc_END -->`, ""} <div class="home__container">${validate_component(Hero, "Hero").$$render($$result, {}, {}, {})} ${validate_component(Funnel, "Funnel").$$render($$result, {}, {}, {})} ${validate_component(AviationExperience, "AviationExperience").$$render($$result, {}, {}, {})} ${validate_component(MainPrograms, "MainPrograms").$$render($$result, {}, {}, {})} ${validate_component(CareerMission, "CareerMission").$$render($$result, {}, {}, {})} ${validate_component(SpecialPrograms, "SpecialPrograms").$$render($$result, {}, {}, {})} ${validate_component(Financing, "Financing").$$render($$result, {}, {}, {})} ${validate_component(Reviews, "Reviews").$$render($$result, {}, {}, {})} ${validate_component(Contact, "Contact").$$render($$result, {}, {}, {})}</div>`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-d1c39175.js.map
