import { c as create_ssr_component, v as validate_component, d as add_styles } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';

const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/taxi.bbc253f0.avif 1x, /_app/immutable/assets/taxi.cb868646.avif 2x",
    webp: "/_app/immutable/assets/taxi.9b4d4cf9.webp 1x, /_app/immutable/assets/taxi.08892393.webp 2x",
    jpeg: "/_app/immutable/assets/taxi.3408e390.jpg 1x, /_app/immutable/assets/taxi.42c17507.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/taxi.42c17507.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src2 = {
  sources: {
    avif: "/_app/immutable/assets/accelerated_private.a787b934.avif 1x, /_app/immutable/assets/accelerated_private.d41e74de.avif 2x",
    webp: "/_app/immutable/assets/accelerated_private.c5ad770a.webp 1x, /_app/immutable/assets/accelerated_private.044e4020.webp 2x",
    jpeg: "/_app/immutable/assets/accelerated_private.bfd58d82.jpg 1x, /_app/immutable/assets/accelerated_private.95e2557f.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/accelerated_private.95e2557f.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src3 = {
  sources: {
    avif: "/_app/immutable/assets/Landscape4.0946fddd.avif 1x, /_app/immutable/assets/Landscape4.87bb9d53.avif 2x",
    webp: "/_app/immutable/assets/Landscape4.3bb20b78.webp 1x, /_app/immutable/assets/Landscape4.1a312f02.webp 2x",
    jpeg: "/_app/immutable/assets/Landscape4.b4c899be.jpg 1x, /_app/immutable/assets/Landscape4.8102f417.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/Landscape4.8102f417.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src4 = {
  sources: {
    avif: "/_app/immutable/assets/accelerated_career.07fcd031.avif 1x, /_app/immutable/assets/accelerated_career.866b8073.avif 2x",
    webp: "/_app/immutable/assets/accelerated_career.f4c279e3.webp 1x, /_app/immutable/assets/accelerated_career.89c0719d.webp 2x",
    jpeg: "/_app/immutable/assets/accelerated_career.5a4c63e5.jpg 1x, /_app/immutable/assets/accelerated_career.ec481c31.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/accelerated_career.ec481c31.jpg",
    w: 6e3,
    h: 4e3
  }
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `${$$result.head += `<!-- HEAD_svelte-raj4at_START -->${$$result.title = `<title>Accelerated Training | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation accelerated training"><!-- HEAD_svelte-raj4at_END -->`, ""} ${validate_component(Hero, "Hero").$$render($$result, { alt: "", src: hero_src }, {}, {
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-ch9446">At First Landings Aviation, we offer Accelerated CFI training, Accelerated Instrument
		training, Accelerated PPL training as well as Accelerated Commercial flight training
		programs which cater to students aiming to complete their certificates in a shorter period
		of time by training more frequently.</div>`;
    },
    titleTwo: () => {
      return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1m6f75k">Pilot Program</span>`;
    },
    titleOne: () => {
      return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-u6k4s1">Accelerated</span>`;
    }
  })} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return ` ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          id: "private",
          alt: "Accelerated private pilot training",
          color: "blue",
          src: content_src2
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-ktaak3">Our Private Pilot Accelerated Program is an intensive 3-week course that gets you
			prepared to become a safe and competent pilot through our advanced training techniques
			to help you achieve your FAA Private Pilot certification. Our facilities include a
			luxurious pilot’s lounge and area for students to study and work with each other while
			here, and get you read to pass the practical test.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-dsfpij">Private Pilot</span>`;
          }
        }
      )} ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          id: "instrument",
          alt: "Accelerated instrument pilot training",
          src: content_src3
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-1sccilo">Our Accelerated IFR training program is an intensive 7-day course that when you’re
			finished, you’ll have gained solid experience in the real world of IFR. This course is
			intended for those serious about adding an instrument rating to their private license,
			and want to get it done fast and efficiently. This course assumes the student has a
			Private Pilot License and 50 hours of PIC cross country time, including at least 25
			hours of simulated or actual instrument time. If more time is needed, the student will
			pay for the normal rental of the aircraft beyond the 15 hours.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-ybmtbk">Instrument Rating</span>`;
          }
        }
      )} ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          id: "career",
          alt: "Accelerated career pilot training",
          color: "blue",
          src: content_src4
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-110awj7">The Accelerated Career Pilot Program is a full-time path to your pilot career. Once
			enrolled, you will experience an intense training curriculum that requires daily
			attendance. Your days will be filled with classroom-based academic ground school and
			flight instruction in our aircraft. Graduates of the Core Module will obtain all
			certificates and ratings required to become a fully qualified Commercial Pilot. The
			Instructor Module enables students to earn their flight instructor ratings, allowing
			them to increase their experience through flight instruction.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-npbc7y">Career Pilot</span>`;
          }
        }
      )}`;
    }
  })}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-d90dc259.js.map
