const GET = async ({ fetch }) => {
  const response = await fetch(`https://admin.firstlandings.com/api/blog/posts`);
  let posts = await response.json();
  let blogPosts = posts.filter((post) => post.published);
  const baseUrl = "https://www.firstlandings.com";
  const sitemap = `<?xml version="1.0" encoding="UTF-8"?>
  <urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
      xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
            http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
<url>
<loc>https://www.firstlandings.com/</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>1.00</priority>
</url>
<url>
<loc>https://www.firstlandings.com/about-us</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/blog</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/services/private-pilot</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/services/instrument-rating</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/services/professional-pilot-program</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/services/accelerated-training</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/services/commercial-pilot</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/services/multi-engine-rating</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/services/flight-instructor</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/services/international-students</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/services/dgca-india</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/contact-us</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/financing</loc>
<lastmod>2024-08-07T19:57:22+00:00</lastmod>
<priority>0.80</priority>
</url>
<url>
<loc>https://www.firstlandings.com/FLAP%20-%20OFA%20SEVIS%20Application%20Form.docx</loc>
<lastmod>2024-03-18T01:41:56+00:00</lastmod>
<priority>0.64</priority>
</url>
    ${blogPosts.map(
    (post) => `
    <url>
      <loc>${baseUrl}/blog/${post.slug}</loc>
      <lastmod>${post.changed_at}</lastmod>
      <changefreq>weekly</changefreq>
      <priority>0.7</priority>
    </url>
    `
  ).join("")}
  </urlset>`;
  return new Response(sitemap, {
    headers: {
      "Content-Type": "application/xml"
    }
  });
};

export { GET };
//# sourceMappingURL=_server.ts-54b229c8.js.map
