const url = "https://www.firstlandings.com";
async function GET({ fetch }) {
  const response = await fetch(`https://admin.firstlandings.com/api/blog/posts`);
  let posts = await response.json();
  posts = posts.filter((post) => post.published);
  const headers = { "Content-Type": "application/xml" };
  const xml = `
		<rss xmlns:atom="http://www.w3.org/2005/Atom" version="2.0">
			<channel>
				<title>First Landings Aviation</title>
				<description>Flight school blog post</description>
				<link>${url}</link>
				<atom:link href="${url}/rss.xml" rel="self" type="application/rss+xml"/>
				${posts.map(
    (post) => `
						<item>
							<title>${post.title}</title>
							<description>${post.description}</description>
							<link>${url}/${post.slug}</link>
							<guid isPermaLink="true">${url}/${post.slug}</guid>
							<pubDate>${new Date(post.changed_at).toUTCString()}</pubDate>
						</item>
					`
  ).join("")}
			</channel>
		</rss>
	`.trim();
  return new Response(xml, { headers });
}

export { GET };
//# sourceMappingURL=_server.ts-eacd2484.js.map
