import { e as error } from './index-916a7dc8.js';
import { s as stylesheet_6 } from './6-9edbea45.js';

const load = async ({ fetch, params }) => {
  let res;
  try {
    res = await fetch(`https://admin.firstlandings.com/api/blog/posts`);
    const posts = await res.json();
    res = await fetch(`https://admin.firstlandings.com/api/blog/posts/${params.slug}`);
    const post = await res.json();
    if (post.detail) {
      throw error(404, "Post not Found");
    }
    res = await fetch(`https://admin.firstlandings.com/api/blog/sections`);
    let sections = await res.json();
    sections = sections.filter((el) => {
      return el.post == post.id;
    });
    post.sections = sections;
    res = await fetch(`https://admin.firstlandings.com/api/blog/post-tags`);
    const tags = await res.json();
    const tagMap = {};
    tags.forEach((tag) => {
      tagMap[tag.id] = tag.name;
    });
    post.tags = post.tags.map((tagId) => {
      const tag = tags.find((tag2) => tag2.id === tagId);
      return tag ? tag.name : null;
    });
    return { posts, post };
  } catch (e) {
    throw error(e?.status, `${e?.body.message}`);
  }
};

var _page_ts = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

// _app/immutable/assets/6.f3e669b7.css
var stylesheet_5 = ".slug.svelte-dlboxx{display:flex;flex-direction:column;padding:5rem 26rem}@media screen and (max-width:1024px){.slug.svelte-dlboxx{padding:5rem 13rem}}@media screen and (max-width:768px){.slug.svelte-dlboxx{padding:5rem 6.5rem}}.grid.svelte-dlboxx{display:grid;grid-template-columns:1fr;gap:2rem}@media screen and (min-width:1280px){.grid.svelte-dlboxx{grid-template-columns:1fr 25rem}}.hero.svelte-dlboxx{display:flex;flex-direction:column;gap:1.5rem}.hero__image.svelte-dlboxx{width:100%;max-height:75rem;-o-object-fit:cover;object-fit:cover}.hero__date.svelte-dlboxx,.hero__heading.svelte-dlboxx,.hero__subheading.svelte-dlboxx{color:#15181c;line-height:normal;white-space:pre-line}.hero__heading.svelte-dlboxx{font-size:3rem}.hero__subheading.svelte-dlboxx{font-size:1.8rem;font-weight:400}.hero__date.svelte-dlboxx{font-size:1rem;margin:0}.tags.svelte-dlboxx{display:flex;flex-wrap:wrap;gap:.5rem}.tag.svelte-dlboxx{font-size:1.2rem;padding:.5rem 1rem;border-radius:4rem;background:#0e76bc}.post__content.svelte-dlboxx{color:#15181c;line-height:normal;white-space:pre-line;width:100%;font-size:1.8rem}.post__section.svelte-dlboxx{padding-block:2rem;display:flex;flex-direction:column;gap:1rem}.post__section--alt.svelte-dlboxx,.post__section--content.svelte-dlboxx,.post__section--subtitle.svelte-dlboxx{color:#15181c}.post__section--subtitle.svelte-dlboxx{font-size:2.6rem}.post__section--image.svelte-dlboxx{width:100%}.latest.svelte-dlboxx{height:-moz-min-content;height:min-content}.latest__heading.svelte-dlboxx{color:#2d3744;font-size:3rem;margin-bottom:2rem}.latest__grid.svelte-dlboxx{display:grid;grid-template-columns:repeat(auto-fit,minmax(20rem,1fr));gap:2rem}@media screen and (max-width:640px){.latest__grid.svelte-dlboxx{display:flex;flex-direction:column}}.latest__card.svelte-dlboxx{text-decoration:none;max-width:30rem}@media screen and (max-width:640px){.latest__card.svelte-dlboxx{max-width:none}}\n";

const index = 6;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-d5249e95.js')).default;
const universal_id = "src/routes/blog/[slug]/+page.ts";
const imports = ["_app/immutable/nodes/6.4bcc157a.js","_app/immutable/chunks/BlogContentCard.3c3d172f.js","_app/immutable/chunks/control.f5b05b5f.js","_app/immutable/chunks/scheduler.5b890119.js","_app/immutable/chunks/index.1673eb25.js","_app/immutable/chunks/each.15f1f0ab.js"];
const stylesheets = ["_app/immutable/assets/6.f3e669b7.css","_app/immutable/assets/BlogContentCard.ad128bc8.css"];
const fonts = [];
const inline_styles = () => ({
	"_app/immutable/assets/6.f3e669b7.css": stylesheet_5,
	"_app/immutable/assets/BlogContentCard.ad128bc8.css": stylesheet_6
});

export { component, fonts, imports, index, inline_styles, stylesheets, _page_ts as universal, universal_id };
//# sourceMappingURL=6-587f0188.js.map
