import transporter from '@sendgrid/mail';
import { f as fail } from './index-916a7dc8.js';
import 'dotenv/config';
import { s as stylesheet_9 } from './9-6e7cc6e6.js';
import { s as stylesheet_13 } from './13-4d26f6a7.js';
import { s as stylesheet_20 } from './20-9ce88af7.js';
import { s as stylesheet_10 } from './10-33703850.js';

transporter.setApiKey("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");
const actions = {
  submit: async ({ request }) => {
    const formData = await request.formData();
    const name = String(formData.get("name"));
    const email = String(formData.get("email"));
    const country = String(formData.get("country"));
    const message = String(formData.get("message"));
    const errors = {};
    const alphaRegex = /^[ a-zA-Z\-\']+$/;
    const emailRegex = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|.(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    if (!name || typeof name !== "string") {
      errors.name = "Name Required";
    } else if (!alphaRegex.test(name)) {
      errors.name = "Letters Only!";
    }
    if (!email || typeof email !== "string") {
      errors.email = "Email Required";
    } else if (!emailRegex.test(email)) {
      errors.email = "Email Not Valid";
    }
    if (!message || typeof message !== "string") {
      errors.message = "Message Required";
    }
    if (Object.keys(errors).length > 0) {
      const data = {
        data: Object.fromEntries(formData),
        errors
      };
      return fail(400, data);
    }
    const emailPayload = {
      to: "info@firstlandings.com",
      from: "dev@firstlandings.com",
      subject: "FirstLandings.com Contact Form Submission",
      html: `
                <strong>Name:</strong>
                <br>
                ${name}
                <br><br>
                <strong>Email:</strong>
                <br>
                ${email}
                <br><br>
                <strong>Country:</strong>
                <br>
                ${country}
                <br><br>
                <strong>Message:</strong>
                <br>
                ${message}
                `
    };
    transporter.send(emailPayload).then(() => {
      return { success: true };
    }).catch((error) => {
      return fail(500, error.response.body);
    });
  }
};

var _page_server_ts = /*#__PURE__*/Object.freeze({
  __proto__: null,
  actions: actions
});

// _app/immutable/assets/7.616a205f.css
var stylesheet_7 = ".wrapper.svelte-le8dnu.svelte-le8dnu{display:flex;flex-direction:column}.wrapper.svelte-le8dnu .header.svelte-le8dnu{display:flex;gap:2rem;padding:5rem}@media (max-width:800px){.wrapper.svelte-le8dnu .header.svelte-le8dnu{flex-direction:column;padding-bottom:0}}.title.svelte-le8dnu.svelte-le8dnu{font-family:REM Variable;font-size:8rem;font-weight:700;text-transform:uppercase}@media screen and (max-width:1024px){.title.svelte-le8dnu.svelte-le8dnu{font-size:6.5rem}}@media screen and (max-width:768px){.title.svelte-le8dnu.svelte-le8dnu{font-size:5rem;text-align:center}}.title.svelte-le8dnu span.svelte-le8dnu{display:inline-block}.title--blue.svelte-le8dnu.svelte-le8dnu{background-color:#0e76bc;padding:0 2rem}.title--orange.svelte-le8dnu.svelte-le8dnu{background-color:#f36d21;padding:0 2rem}.icon-cards.svelte-le8dnu.svelte-le8dnu{display:flex;padding:10rem;flex-wrap:wrap;justify-content:center;gap:7.5rem;background-color:#fff}@media (max-width:800px){.icon-cards.svelte-le8dnu.svelte-le8dnu{flex-direction:column;padding:5rem .5rem;gap:2.5rem}}.contact.svelte-le8dnu.svelte-le8dnu{padding:13.33rem 10vw}@media (max-width:800px){.contact.svelte-le8dnu.svelte-le8dnu{padding:5rem .5rem}}.map.svelte-le8dnu.svelte-le8dnu{display:flex;justify-content:center;border-radius:2rem;overflow:hidden;border:.3rem solid #0e76bc;margin:0 5rem 5rem;height:60rem}@media (max-width:768px){.map.svelte-le8dnu.svelte-le8dnu{margin:0;height:80vh;border-radius:0;border:0}}.content.svelte-le8dnu.svelte-le8dnu{font-size:1.6rem}.content.svelte-le8dnu p.svelte-le8dnu{text-align:center;line-height:normal}\n";

const index = 7;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-e2c6525f.js')).default;
const server_id = "src/routes/contact-us/+page.server.ts";
const imports = ["_app/immutable/nodes/7.2c994aff.js","_app/immutable/chunks/scheduler.5b890119.js","_app/immutable/chunks/index.1673eb25.js","_app/immutable/chunks/each.15f1f0ab.js","_app/immutable/chunks/Modal.2067ceaa.js","_app/immutable/chunks/parse.bee59afc.js","_app/immutable/chunks/singletons.f215563a.js","_app/immutable/chunks/index.852d6942.js","_app/immutable/chunks/Input.407603bd.js","_app/immutable/chunks/Button.65ff2d6b.js","_app/immutable/chunks/ContentCard.e15d56dd.js","_app/immutable/chunks/EmailFast.13b2dab2.js","_app/immutable/chunks/Phone.0c22d3d1.js"];
const stylesheets = ["_app/immutable/assets/7.616a205f.css","_app/immutable/assets/Modal.0d197995.css","_app/immutable/assets/Input.8fc26899.css","_app/immutable/assets/Button.4c43b995.css","_app/immutable/assets/ContentCard.b5a2f49f.css","_app/immutable/assets/EmailFast.7993c7f1.css"];
const fonts = [];
const inline_styles = () => ({
	"_app/immutable/assets/7.616a205f.css": stylesheet_7,
	"_app/immutable/assets/Input.8fc26899.css": stylesheet_9,
	"_app/immutable/assets/Button.4c43b995.css": stylesheet_13,
	"_app/immutable/assets/ContentCard.b5a2f49f.css": stylesheet_20,
	"_app/immutable/assets/EmailFast.7993c7f1.css": stylesheet_10
});

export { component, fonts, imports, index, inline_styles, _page_server_ts as server, server_id, stylesheets };
//# sourceMappingURL=7-68201a2c.js.map
