import { c as create_ssr_component, v as validate_component, e as escape } from './ssr-73f02b7a.js';
import { B as Button } from './Button-b4fad8e7.js';

const css = {
  code: ".funnel__card.svelte-nt9c8w{display:flex;flex-direction:column;align-items:center;gap:2.5rem;padding:2.5rem;background-color:#fff;border:0.3rem solid #0e76bc;border-radius:4rem;color:#0e76bc;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1)}.funnel__card--title.svelte-nt9c8w{font-family:'REM Variable', Inter, sans-serif;font-size:3rem;font-weight:700;text-transform:uppercase;text-align:center}@media screen and (max-width: 1536px){.funnel__card--title.svelte-nt9c8w{padding-left:5%;padding-right:5%}}@media screen and (max-width: 1280px){.funnel__card--title.svelte-nt9c8w{padding-left:0;padding-right:0}}.funnel__card--main.svelte-nt9c8w{font-size:1.8rem;line-height:normal;margin:0}.funnel__card--icon.svelte-nt9c8w{height:17rem;margin-top:auto}.seperator.svelte-nt9c8w{border:none;border-top:0.1px solid #0e76bc;margin:0}",
  map: null
};
const FunnelCard = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { href = void 0 } = $$props;
  let { button = void 0 } = $$props;
  let { icon = false } = $$props;
  if ($$props.href === void 0 && $$bindings.href && href !== void 0)
    $$bindings.href(href);
  if ($$props.button === void 0 && $$bindings.button && button !== void 0)
    $$bindings.button(button);
  if ($$props.icon === void 0 && $$bindings.icon && icon !== void 0)
    $$bindings.icon(icon);
  $$result.css.add(css);
  return `<section class="funnel__card svelte-nt9c8w"><h2 class="funnel__card--title svelte-nt9c8w">${slots.title ? slots.title({}) : ``} <hr class="seperator svelte-nt9c8w"></h2> <p class="funnel__card--main svelte-nt9c8w">${slots.main ? slots.main({}) : ``}</p> ${icon ? `<div class="funnel__card--icon svelte-nt9c8w">${slots.icon ? slots.icon({}) : ``}</div>` : ``} ${href && button ? `<div class="funnel__card--button">${validate_component(Button, "Button").$$render($$result, { href, size: "large" }, {}, {
    default: () => {
      return `${escape(button)}`;
    }
  })}</div>` : ``} </section>`;
});

export { FunnelCard as F };
//# sourceMappingURL=FunnelCard-7733fd41.js.map
