import { c as create_ssr_component, f as each } from './ssr-73f02b7a.js';

const css = {
  code: ".Prerequisites.svelte-18rn20w{background-color:#fff;border:0.3rem solid #f36d21;display:flex;flex-direction:column;width:100%;height:min-content;border-radius:4rem;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1);padding:5rem 5rem}@media screen and (max-width: 768px){.Prerequisites.svelte-18rn20w{padding:5rem 2.5rem}}.Prerequisites__heading.svelte-18rn20w{display:flex;flex-direction:column;align-items:center;width:100%;padding-bottom:1rem}.Prerequisites__heading--h2.svelte-18rn20w{font-size:4.4rem;font-weight:700;font-family:'REM Variable';text-align:center}.Prerequisites__heading--orange.svelte-18rn20w{color:#f36d21;text-decoration:underline}.Prerequisites__heading--blue.svelte-18rn20w{color:#0e76bc;text-decoration:underline}.Prerequisites__heading--paragraph.svelte-18rn20w{font-size:1.8rem;font-weight:400;color:#15181c;text-align:center;max-width:50rem;line-height:normal}.Prerequisites__main.svelte-18rn20w{display:grid;grid-template-columns:repeat(auto-fit, minmax(1rem, 1fr));gap:0.5rem}@media screen and (max-width: 1536px){.Prerequisites__main.svelte-18rn20w{grid-template-columns:minmax(1rem, 1fr);gap:2rem}}.Prerequisites__card.svelte-18rn20w{padding:3.4rem 3rem;display:flex;flex-direction:column;gap:2rem}.Prerequisites__card--blue.svelte-18rn20w{border:0.3rem solid #0e76bc;border-radius:2.6rem}.Prerequisites__card--orange.svelte-18rn20w{border:0.3rem solid #f36d21;border-radius:2.6rem}.Prerequisites__card--heading.svelte-18rn20w{font-size:3.2rem;font-weight:600;text-transform:uppercase;padding:0.5rem 0;text-align:center;border-radius:5px}.Prerequisites__card--headingBlue.svelte-18rn20w{background-color:#0e76bc}.Prerequisites__card--headingOrange.svelte-18rn20w{background-color:#f36d21}.Prerequisites__card--list.svelte-18rn20w{font-size:1.6rem;color:#15181c;display:flex;flex-direction:column;gap:1rem}.Prerequisites__card--item.svelte-18rn20w{line-height:normal}",
  map: null
};
const Prerequisites = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { prerequisites } = $$props;
  if ($$props.prerequisites === void 0 && $$bindings.prerequisites && prerequisites !== void 0)
    $$bindings.prerequisites(prerequisites);
  $$result.css.add(css);
  return `<article class="Prerequisites svelte-18rn20w"><section class="Prerequisites__heading svelte-18rn20w" data-svelte-h="svelte-ajqcx2"><h2 class="Prerequisites__heading--h2 svelte-18rn20w"><span class="Prerequisites__heading--orange svelte-18rn20w">Checkride</span> <span class="Prerequisites__heading--blue svelte-18rn20w">Prerequisites</span></h2> <p class="Prerequisites__heading--paragraph svelte-18rn20w">There&#39;s just a few things for you to check off before we can get your
            checkride scheduled</p></section> <section class="Prerequisites__main svelte-18rn20w"><div class="Prerequisites__card Prerequisites__card--blue svelte-18rn20w"><h3 class="Prerequisites__card--heading Prerequisites__card--headingBlue svelte-18rn20w" data-svelte-h="svelte-v3bb44">Eligibility Requirements</h3> <ul class="Prerequisites__card--list svelte-18rn20w">${each(prerequisites.eligibility, (item) => {
    return `<li class="Prerequisites__card--item svelte-18rn20w"><!-- HTML_TAG_START -->${item}<!-- HTML_TAG_END --> </li>`;
  })}</ul></div> <div class="Prerequisites__card Prerequisites__card--orange svelte-18rn20w"><h3 class="Prerequisites__card--heading Prerequisites__card--headingOrange svelte-18rn20w" data-svelte-h="svelte-kv51i8">Flight Proficiency</h3> <ul class="Prerequisites__card--list svelte-18rn20w">${each(prerequisites.proficiency, (item) => {
    return `<li class="Prerequisites__card--item svelte-18rn20w"><!-- HTML_TAG_START -->${item}<!-- HTML_TAG_END --> </li>`;
  })}</ul></div> <div class="Prerequisites__card Prerequisites__card--blue svelte-18rn20w"><h3 class="Prerequisites__card--heading Prerequisites__card--headingBlue svelte-18rn20w" data-svelte-h="svelte-pvusdf">Aeronautical experience</h3> <ul class="Prerequisites__card--list svelte-18rn20w">${each(prerequisites.experience, (item) => {
    return `<li class="Prerequisites__card--item svelte-18rn20w"><!-- HTML_TAG_START -->${item}<!-- HTML_TAG_END --> </li>`;
  })}</ul></div></section> </article>`;
});

export { Prerequisites as P };
//# sourceMappingURL=Prerequisites-09460ce9.js.map
