import { c as create_ssr_component, v as validate_component, b as add_attribute, a as subscribe, f as each, e as escape } from './ssr-73f02b7a.js';
import { P as Plus, F as FridgeMagnet } from './Plus-6453516c.js';
import { B as Button } from './Button-b4fad8e7.js';
import { F as Financing } from './Financing-541250c1.js';
import { w as writable } from './index2-caf24a5d.js';
import { p as page } from './stores-bcb43e00.js';
import { R as Reviews, C as Contact } from './Contact-67961899.js';
import './four_planes-09dc2ee5.js';

const css$5 = {
  code: ".program__card.svelte-18vt2oq{display:flex;flex-direction:column;align-items:center;gap:2.5rem;padding:2.5rem 1rem;border:0.3rem solid #0e76bc;border-radius:1.5rem;background-color:#fff;color:#15181c;max-width:20rem}@media screen and (max-width: 1024px){.program__card.svelte-18vt2oq{width:100%;max-width:none;margin:0 auto;border-radius:4rem;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1)}}.program__card--icon.svelte-18vt2oq{width:80%;display:flex;justify-content:center;align-items:center}.program__card--title.svelte-18vt2oq{text-align:center;font-size:1.6rem;font-weight:600;text-transform:capitalize}.program__card--values.svelte-18vt2oq{display:flex;flex-direction:column;align-items:center;gap:1rem;text-align:center;font-weight:500}@media screen and (max-width: 1024px){.program__card--values.svelte-18vt2oq{font-weight:600}}.values.svelte-18vt2oq{font-size:1.6rem;padding:0;margin:0}.values__title--mobile.svelte-18vt2oq{display:none;font-size:1.4rem;font-weight:500;text-transform:capitalize}@media screen and (max-width: 1024px){.values__title--mobile.svelte-18vt2oq{display:inline-block}}.separator.svelte-18vt2oq{border-top:0.1rem solid #0e76bc;width:90%}@media screen and (max-width: 768px){.separator.svelte-18vt2oq{position:relative;left:-50%;width:200%}}",
  map: null
};
const ProgramCard = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$5);
  return `<section class="program__card svelte-18vt2oq"><div class="program__card--icon svelte-18vt2oq">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { color: "#0E76BC" }, {}, {})}</div> <h3 class="program__card--title svelte-18vt2oq">${slots.title ? slots.title({}) : ``}</h3> <div class="program__card--values svelte-18vt2oq"><h3 class="values__title--mobile svelte-18vt2oq" data-svelte-h="svelte-dsnjsn">Aircraft rental</h3> <p class="values svelte-18vt2oq">${slots.rental ? slots.rental({}) : ``}hrs</p> <hr class="separator svelte-18vt2oq"> <h3 class="values__title--mobile svelte-18vt2oq" data-svelte-h="svelte-6sb923">Flight instruction</h3> <p class="values svelte-18vt2oq">${slots.flight ? slots.flight({}) : ``}hrs</p> <hr class="separator svelte-18vt2oq"> <h3 class="values__title--mobile svelte-18vt2oq" data-svelte-h="svelte-bsegdy">Ground instruction</h3> <p class="values svelte-18vt2oq">${slots.ground ? slots.ground({}) : ``}hrs</p> <hr class="separator svelte-18vt2oq"> <h3 class="values__title--mobile svelte-18vt2oq" data-svelte-h="svelte-1d657nx">Included</h3> <p class="values svelte-18vt2oq">${slots.included ? slots.included({}) : ``}</p> <hr class="separator svelte-18vt2oq"> <h3 class="values__title--mobile svelte-18vt2oq" data-svelte-h="svelte-1p6e8hn">Cost (USD)</h3> <p class="values svelte-18vt2oq">$${slots.cost ? slots.cost({}) : ``}</p></div> <div class="program__card--button">${validate_component(Button, "Button").$$render($$result, { href: "/contact-us" }, {}, {
    default: () => {
      return `Enroll`;
    }
  })}</div> </section>`;
});
const css$4 = {
  code: ".programs.svelte-9kpndd{margin:0 2.5rem;padding:5rem 0;overflow:hidden}@media screen and (max-width: 768px){.programs.svelte-9kpndd{padding:5rem 2rem 5rem 2rem}}.programs__title.svelte-9kpndd{padding-bottom:3rem;font-size:3rem;text-transform:capitalize;color:#000}@media screen and (max-width: 768px){.programs__title.svelte-9kpndd{text-align:center}}.programs__index.svelte-9kpndd{align-self:flex-end;padding-bottom:9.5rem;display:flex;flex-direction:column;gap:1rem;color:#15181c;text-transform:capitalize}@media screen and (max-width: 1024px){.programs__index.svelte-9kpndd{display:none}}.programs__details.svelte-9kpndd{display:flex;gap:2.5rem;overflow-x:auto}@media screen and (max-width: 1024px){.programs__details.svelte-9kpndd{width:100%;padding:0 8rem;display:flex;flex-direction:column;gap:5rem;overflow:visible}}@media screen and (max-width: 768px){.programs__details.svelte-9kpndd{padding:0;gap:2rem}}.flexed.svelte-9kpndd{display:flex;gap:5rem}.index__title.svelte-9kpndd{width:max-content;font-size:1.6rem;font-weight:600}.relative.svelte-9kpndd{position:relative;height:1em}.separator.svelte-9kpndd{position:absolute;width:100vw;z-index:-1;border-top:0.1rem solid #0e76bc}",
  map: null
};
const Programs = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$4);
  return `<article class="programs svelte-9kpndd"><h2 class="programs__title svelte-9kpndd" data-svelte-h="svelte-2pe0at">Pilot programs</h2> <div class="flexed svelte-9kpndd"><section class="programs__index svelte-9kpndd" data-svelte-h="svelte-1wvu5vi"><h3 class="index__title svelte-9kpndd">Aircraft rental</h3> <div class="relative svelte-9kpndd"><hr class="separator svelte-9kpndd"></div> <h3 class="index__title svelte-9kpndd">Flight instruction</h3> <div class="relative svelte-9kpndd"><hr class="separator svelte-9kpndd"></div> <h3 class="index__title svelte-9kpndd">Ground instruction</h3> <div class="relative svelte-9kpndd"><hr class="separator svelte-9kpndd"></div> <h3 class="index__title svelte-9kpndd">Included</h3> <div class="relative svelte-9kpndd"><hr class="separator svelte-9kpndd"></div> <h3 class="index__title svelte-9kpndd">Cost (USD)</h3></section> <section class="programs__details svelte-9kpndd"> ${validate_component(ProgramCard, "ProgramCard").$$render($$result, {}, {}, {
    cost: () => {
      return `<span slot="cost" data-svelte-h="svelte-ize8jy">13,222.00</span>`;
    },
    included: () => {
      return `<span slot="included" data-svelte-h="svelte-33hm2p">Pilot kit</span>`;
    },
    ground: () => {
      return `<span slot="ground" data-svelte-h="svelte-131i5il">10</span>`;
    },
    flight: () => {
      return `<span slot="flight" data-svelte-h="svelte-1ky9r2o">25</span>`;
    },
    rental: () => {
      return `<span slot="rental" data-svelte-h="svelte-o8acl5">40</span>`;
    },
    title: () => {
      return `<span slot="title" data-svelte-h="svelte-mgtve4">Private pilot</span>`;
    }
  })} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, {}, {}, {
    cost: () => {
      return `<span slot="cost" data-svelte-h="svelte-13tjc5o">7,555.00</span>`;
    },
    included: () => {
      return `<span slot="included" data-svelte-h="svelte-804pbv">Foreflight</span>`;
    },
    ground: () => {
      return `<span slot="ground" data-svelte-h="svelte-131i5il">10</span>`;
    },
    flight: () => {
      return `<span slot="flight" data-svelte-h="svelte-1odxbkz">15</span>`;
    },
    rental: () => {
      return `<span slot="rental" data-svelte-h="svelte-yjvqy3">20</span>`;
    },
    title: () => {
      return `<span slot="title" data-svelte-h="svelte-xc0nhb">Instrument rating</span>`;
    }
  })} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, {}, {}, {
    cost: () => {
      return `<span slot="cost" data-svelte-h="svelte-ofsa04">9,841.00</span>`;
    },
    included: () => {
      return `<span slot="included" data-svelte-h="svelte-n9whil">N/A</span>`;
    },
    ground: () => {
      return `<span slot="ground" data-svelte-h="svelte-131i5il">10</span>`;
    },
    flight: () => {
      return `<span slot="flight" data-svelte-h="svelte-1ky9r2o">25</span>`;
    },
    rental: () => {
      return `<span slot="rental" data-svelte-h="svelte-146s2h8">25</span>`;
    },
    title: () => {
      return `<span slot="title" data-svelte-h="svelte-69fpw7">Commercial SEL</span>`;
    }
  })} ${validate_component(ProgramCard, "ProgramCard").$$render($$result, {}, {}, {
    cost: () => {
      return `<span slot="cost" data-svelte-h="svelte-o9pluq">7,742.00</span>`;
    },
    included: () => {
      return `<span slot="included" data-svelte-h="svelte-1435lbu">CBT</span>`;
    },
    ground: () => {
      return `<span slot="ground" data-svelte-h="svelte-131i5il">10</span>`;
    },
    flight: () => {
      return `<span slot="flight" data-svelte-h="svelte-1285ze8">10</span>`;
    },
    rental: () => {
      return `<span slot="rental" data-svelte-h="svelte-qimwxa">12</span>`;
    },
    title: () => {
      return `<span slot="title" data-svelte-h="svelte-1g6cl8k">Multi-Engine Add-On</span>`;
    }
  })}</section></div> </article>`;
});
const css$3 = {
  code: ".rates__card.svelte-t41xkb{display:flex;flex-direction:column;align-items:center;gap:2.5rem;padding:2.5rem 0.5rem;border:0.3rem solid #f36d21;border-radius:1.5rem;background-color:#fff;color:#15181c;max-width:20rem}@media screen and (max-width: 1024px){.rates__card.svelte-t41xkb{width:100%;max-width:none;margin:0 auto;border-radius:4rem;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1)}}.rates__card--icon.svelte-t41xkb{width:80%;display:flex;justify-content:center;align-items:center}.rates__card--title.svelte-t41xkb{text-align:center;font-size:1.6rem;font-weight:600}.rates__card--image.svelte-t41xkb{pointer-events:none}.rates__card--values.svelte-t41xkb{display:flex;flex-direction:column;align-items:center;gap:1rem;text-align:center;font-weight:600}.values__price.svelte-t41xkb{font-size:1.6rem;padding:0;margin:0}.values__title--mobile.svelte-t41xkb{display:none;font-size:1.4rem;font-weight:500;text-transform:capitalize}@media screen and (max-width: 1024px){.values__title--mobile.svelte-t41xkb{display:inline-block}}.separator.svelte-t41xkb{border-top:0.1rem solid #f36d21;width:90%}@media screen and (max-width: 768px){.separator.svelte-t41xkb{position:relative;left:-50%;width:200%}}",
  map: null
};
const RatesCard = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { src } = $$props;
  let { alt } = $$props;
  if ($$props.src === void 0 && $$bindings.src && src !== void 0)
    $$bindings.src(src);
  if ($$props.alt === void 0 && $$bindings.alt && alt !== void 0)
    $$bindings.alt(alt);
  $$result.css.add(css$3);
  return `<section class="rates__card svelte-t41xkb"><div class="rates__card--icon svelte-t41xkb">${validate_component(FridgeMagnet, "Magnet").$$render($$result, {}, {}, {})}</div> <h3 class="rates__card--title svelte-t41xkb">${slots.title ? slots.title({}) : ``}</h3> <img class="rates__card--image svelte-t41xkb"${add_attribute("alt", alt, 0)}${add_attribute("src", src, 0)}> <div class="rates__card--values svelte-t41xkb"><h3 class="values__title--mobile svelte-t41xkb" data-svelte-h="svelte-mm1pag">Hourly rental</h3> <p class="values__price svelte-t41xkb">$${slots.hourly ? slots.hourly({}) : ``}/hr</p> <hr class="separator svelte-t41xkb"> <h3 class="values__title--mobile svelte-t41xkb" data-svelte-h="svelte-1htirj0">Block (50+ hrs)</h3> <p class="values__price svelte-t41xkb">$${slots.block ? slots.block({}) : ``}/hr</p> <hr class="separator svelte-t41xkb"> <h3 class="values__title--mobile svelte-t41xkb" data-svelte-h="svelte-1hscxmb">Instruction</h3> <p class="values__price svelte-t41xkb">$${slots.instruction ? slots.instruction({}) : ``}/hr</p></div> </section>`;
});
const css$2 = {
  code: ".rental.svelte-1nbhrub{margin:0 2.5rem;padding:5rem 0 10rem 0;overflow:hidden}@media screen and (max-width: 768px){.rental.svelte-1nbhrub{padding:0 2rem 5rem 2rem}}.rental__title.svelte-1nbhrub{padding-bottom:3rem;font-size:3rem;text-transform:capitalize;color:#000}@media screen and (max-width: 768px){.rental__title.svelte-1nbhrub{text-align:center}}.rental__index.svelte-1nbhrub{align-self:flex-end;padding-bottom:3.2rem;display:flex;flex-direction:column;gap:1rem;color:#15181c;text-transform:capitalize}@media screen and (max-width: 1024px){.rental__index.svelte-1nbhrub{display:none}}.rental__rates.svelte-1nbhrub{display:flex;gap:2.5rem;overflow-x:auto}@media screen and (max-width: 1024px){.rental__rates.svelte-1nbhrub{width:100%;padding:0 8rem;display:flex;flex-direction:column;gap:5rem;overflow:visible}}@media screen and (max-width: 768px){.rental__rates.svelte-1nbhrub{padding:0;gap:2rem}}.flexed.svelte-1nbhrub{display:flex;gap:2.5rem}.index__title.svelte-1nbhrub{width:max-content;font-size:1.6rem;font-weight:600}.relative.svelte-1nbhrub{position:relative;height:1em}.separator.svelte-1nbhrub{position:absolute;width:100vw;z-index:-1;border-top:0.1rem solid #f36d21}",
  map: null
};
const RentalRates = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$2);
  return `<article class="rental svelte-1nbhrub"><h2 class="rental__title svelte-1nbhrub" data-svelte-h="svelte-1wdjpln">Rental &amp; service rates</h2> <div class="flexed svelte-1nbhrub"><section class="rental__index svelte-1nbhrub" data-svelte-h="svelte-v8b1h4"><h3 class="index__title svelte-1nbhrub">Hourly rental</h3> <div class="relative svelte-1nbhrub"><hr class="separator svelte-1nbhrub"></div> <h3 class="index__title svelte-1nbhrub">Block (50+ hrs)</h3> <div class="relative svelte-1nbhrub"><hr class="separator svelte-1nbhrub"></div> <h3 class="index__title svelte-1nbhrub">Instruction</h3></section> <section class="rental__rates svelte-1nbhrub">   ${validate_component(RatesCard, "RatesCard").$$render(
    $$result,
    {
      alt: "cessna 172S",
      src: "/172SCessna.webp"
    },
    {},
    {
      instruction: () => {
        return `<span slot="instruction" data-svelte-h="svelte-1p9zbe3">79</span>`;
      },
      block: () => {
        return `<span slot="block" data-svelte-h="svelte-pb20gj">184</span>`;
      },
      hourly: () => {
        return `<span slot="hourly" data-svelte-h="svelte-1wvu2t5">199</span>`;
      },
      title: () => {
        return `<span slot="title" data-svelte-h="svelte-laqnu3">Cessna 172S</span>`;
      }
    }
  )} ${validate_component(RatesCard, "RatesCard").$$render(
    $$result,
    {
      alt: "piper pilot 100i",
      src: "/Pilot100iPiper.webp"
    },
    {},
    {
      instruction: () => {
        return `<span slot="instruction" data-svelte-h="svelte-1p9zbe3">79</span>`;
      },
      block: () => {
        return `<span slot="block" data-svelte-h="svelte-ypcig1">209</span>`;
      },
      hourly: () => {
        return `<span slot="hourly" data-svelte-h="svelte-y97264">235</span>`;
      },
      title: () => {
        return `<span slot="title" data-svelte-h="svelte-bjg72h">Piper 100i</span>`;
      }
    }
  )} ${validate_component(RatesCard, "RatesCard").$$render(
    $$result,
    {
      alt: "tecnam p2006t",
      src: "/P2006tTecnam.webp"
    },
    {},
    {
      instruction: () => {
        return `<span slot="instruction" data-svelte-h="svelte-goflup">99</span>`;
      },
      block: () => {
        return `<span slot="block" data-svelte-h="svelte-vzpxxn">320</span>`;
      },
      hourly: () => {
        return `<span slot="hourly" data-svelte-h="svelte-10nwnrw">345</span>`;
      },
      title: () => {
        return `<span slot="title" data-svelte-h="svelte-4vn161">Tecnam P2006t</span>`;
      }
    }
  )}</section></div> </article>`;
});
const css$1 = {
  code: ".discoveryFlight__figure.svelte-zkipze{position:relative;height:100vh;padding:5rem;display:flex;justify-content:space-between;gap:5rem;overflow:hidden}@media screen and (max-width: 1280px){.discoveryFlight__figure.svelte-zkipze{background-position:right center}}@media screen and (max-width: 1024px){.discoveryFlight__figure.svelte-zkipze{flex-direction:column;background-position:bottom}}@media screen and (max-width: 768px){.discoveryFlight__figure.svelte-zkipze{padding:2rem}}@media screen and (max-width: 350px){.discoveryFlight__figure.svelte-zkipze{gap:2rem}}.discoveryFlight__img.svelte-zkipze{pointer-events:none;object-fit:cover;position:absolute;top:50%;left:50%;transform:translate(-50%, -50%);width:100%;height:100%;z-index:-1}.discoveryFlight__headers.svelte-zkipze{display:flex;flex-direction:column;gap:2rem}.discoveryFlight__headers--h3.svelte-zkipze{font-size:4.4rem;font-weight:700;text-transform:uppercase}@media screen and (max-width: 1536px){.discoveryFlight__headers--h3.svelte-zkipze{font-size:4rem}}@media screen and (max-width: 350px){.discoveryFlight__headers--h3.svelte-zkipze{font-size:2rem}}.discoveryFlight__headers--h2.svelte-zkipze{font-size:3rem;font-weight:700;text-transform:uppercase}@media screen and (max-width: 1536px){.discoveryFlight__headers--h2.svelte-zkipze{font-size:2.8rem}}@media screen and (max-width: 350px){.discoveryFlight__headers--h2.svelte-zkipze{font-size:2rem}}.discoveryFlight__text.svelte-zkipze{line-height:normal;font-size:1.8rem;text-align:left}@media screen and (max-width: 1536px){.discoveryFlight__text.svelte-zkipze{font-size:1.7rem}}@media screen and (max-width: 350px){.discoveryFlight__text.svelte-zkipze{font-size:1.4rem}}.discoveryFlight__text--box.svelte-zkipze{max-width:70rem;height:fit-content;display:flex;flex-direction:column;background-color:rgba(0,0,0,0.102);backdrop-filter:blur(20px);border-radius:4rem;padding:3rem 5rem}@media screen and (max-width: 1280px){.discoveryFlight__text--box.svelte-zkipze{flex-shrink:2}}@media screen and (max-width: 1024px){.discoveryFlight__text--box.svelte-zkipze{margin:0 auto}}@media screen and (max-width: 640px){.discoveryFlight__text--box.svelte-zkipze{padding:1rem 3rem;border-radius:2rem}}.discoveryFlight__btn.svelte-zkipze{margin-left:auto}@media screen and (max-width: 1024px){.discoveryFlight__btn.svelte-zkipze{margin:auto}}",
  map: null
};
const DiscoveryFlight = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$1);
  return `<article class="discoveryFlight"><figure class="discoveryFlight__figure svelte-zkipze"><picture data-svelte-h="svelte-zqqxr2"><source${add_attribute("srcset", "/_app/immutable/assets/flying_next_to_clouds.c8d66be6.avif 540w, /_app/immutable/assets/flying_next_to_clouds.440ce15f.avif 768w, /_app/immutable/assets/flying_next_to_clouds.3be83d45.avif 1080w, /_app/immutable/assets/flying_next_to_clouds.cbf0b6d9.avif 1366w, /_app/immutable/assets/flying_next_to_clouds.1a1ad98d.avif 1536w, /_app/immutable/assets/flying_next_to_clouds.6c5a583a.avif 1920w, /_app/immutable/assets/flying_next_to_clouds.21b8207a.avif 2560w, /_app/immutable/assets/flying_next_to_clouds.b7c4eb29.avif 3000w, /_app/immutable/assets/flying_next_to_clouds.7670245a.avif 4096w", 0)} sizes="100vw" type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/flying_next_to_clouds.3402d658.webp 540w, /_app/immutable/assets/flying_next_to_clouds.0d462cc1.webp 768w, /_app/immutable/assets/flying_next_to_clouds.07c40f51.webp 1080w, /_app/immutable/assets/flying_next_to_clouds.1cbebc53.webp 1366w, /_app/immutable/assets/flying_next_to_clouds.0124e374.webp 1536w, /_app/immutable/assets/flying_next_to_clouds.041973ca.webp 1920w, /_app/immutable/assets/flying_next_to_clouds.52c71d76.webp 2560w, /_app/immutable/assets/flying_next_to_clouds.d0a9472b.webp 3000w, /_app/immutable/assets/flying_next_to_clouds.0752c4a2.webp 4096w", 0)} sizes="100vw" type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/flying_next_to_clouds.881a0856.png 540w, /_app/immutable/assets/flying_next_to_clouds.5df8ddb2.png 768w, /_app/immutable/assets/flying_next_to_clouds.17c2a1ce.png 1080w, /_app/immutable/assets/flying_next_to_clouds.7d97f033.png 1366w, /_app/immutable/assets/flying_next_to_clouds.43b93c3e.png 1536w, /_app/immutable/assets/flying_next_to_clouds.46f0ac2e.png 1920w, /_app/immutable/assets/flying_next_to_clouds.712359b4.png 2560w, /_app/immutable/assets/flying_next_to_clouds.d053e85b.png 3000w, /_app/immutable/assets/flying_next_to_clouds.dce61918.png 4096w", 0)} sizes="100vw" type="image/png"><img class="discoveryFlight__img svelte-zkipze" alt="Pilot flying next to clouds" src="/_app/immutable/assets/flying_next_to_clouds.dce61918.png" width="4096" height="2732"></picture> <section class="discoveryFlight__headers svelte-zkipze" data-svelte-h="svelte-1l4eo1c"><h2 class="discoveryFlight__headers--h2 svelte-zkipze">DISCOVERY FLIGHT</h2> <h3 class="discoveryFlight__headers--h3 svelte-zkipze">KICK START YOUR AVIATION EXPERIENCE</h3></section> <section class="discoveryFlight__text--box svelte-zkipze"><p class="discoveryFlight__text svelte-zkipze" data-svelte-h="svelte-tw9j3n">We offer a 1-hour discovery flight to give you the opportunity to experience taking
                to the air. A certified flight instructor will demonstrate preflight and flying
                techniques before you climb aboard, will taxi down the runway and before you know
                it, you are in the air! During the flight, you will have the opportunity to control
                the plane through the sky and try out several maneuvers before the pilot takes over
                again for landing. At the subsequent debriefing, guests pen their first logbook
                entry and review their performance.</p> <div class="discoveryFlight__btn svelte-zkipze">${validate_component(Button, "Button").$$render($$result, { color: "orange", href: "/contact-us" }, {}, {
    default: () => {
      return `Book your discovery flight`;
    }
  })}</div></section></figure> </article>`;
});
const faqs = writable({
  "sport-pilot": [
    {
      question: "What is a sport pilot license?",
      answer: "A sport pilot license is a type of pilot certificate issued by aviation authorities, such as the FAA in the United States. It is a more accessible and affordable option for those who want to fly for recreational purposes. Sport pilots are limited in the size and speed of the aircraft they can operate, typically flying light sport aircraft (LSA). The training requirements for a sport pilot license are less stringent than those for a private pilot license.",
      opened: false
    },
    {
      question: "Can I work while taking the course?",
      answer: "Many students work part-time while pursuing their PPL. However, it's essential to balance your time effectively to ensure successful completion of the course.",
      opened: false
    },
    {
      question: "Can I choose when to schedule my flight lessons?",
      answer: "Yes, flight lessons are often flexible and can be scheduled to fit your availability, as long as your flight instructor is available.",
      opened: false
    }
  ],
  "private-pilot": [
    {
      question: "What is a Private Pilot License (PPL)?",
      answer: "A Private Pilot License (PPL) is a certificate that allows individuals to operate aircraft for personal use and non-commercial purposes. It's the first step towards becoming a pilot.",
      opened: false
    },
    {
      question: "Do I need any prior experience to start a private pilot course?",
      answer: "No prior experience is required. Private pilot courses are designed for beginners. However, you must be at least 17 years old to apply for a PPL.",
      opened: false
    },
    {
      question: "How long does it take to get a private pilot license?",
      answer: "The duration of the course can vary depending on factors like your availability and the flight school's curriculum. On average, it takes about 3 to 6 months to earn a PPL.",
      opened: false
    },
    {
      question: "Can I work while taking the course?",
      answer: "Many students work part-time while pursuing their PPL. However, it's essential to balance your time effectively to ensure successful completion of the course.",
      opened: false
    },
    {
      question: "What subjects will I study during the private pilot course?",
      answer: "You will study a range of topics, including aerodynamics, navigation, meteorology, aircraft systems, regulations, and flight planning.",
      opened: false
    },
    {
      question: "Can I choose when to schedule my flight lessons?",
      answer: "Yes, flight lessons are often flexible and can be scheduled to fit your availability, as long as your flight instructor is available.",
      opened: false
    }
  ],
  "instrument-rating": [
    {
      question: "What is IFR in aviation",
      answer: "IFR is a set of regulations and procedures that govern flying in conditions where visual flight references are not sufficient. This involves flying with reference to instruments and navigation aids rather than relying solely on visual cues. IFR allows pilots to fly in low visibility, clouds, and adverse weather conditions, ensuring safety and accurate navigation.",
      opened: false
    },
    {
      question: "Can I work while taking the course?",
      answer: "Many students work part-time while pursuing their PPL. However, it's essential to balance your time effectively to ensure successful completion of the course.",
      opened: false
    },
    {
      question: "Can I choose when to schedule my flight lessons?",
      answer: "Yes, flight lessons are often flexible and can be scheduled to fit your availability, as long as your flight instructor is available.",
      opened: false
    }
  ],
  "professional-pilot-program": [],
  "accelerated-training": [],
  "commercial-pilot": [
    {
      question: "What is a commercial pilot?",
      answer: "A commercial pilot is a licensed aviator who is authorized to be compensated for their flying services. They can be employed as pilots for various purposes, including airline, cargo, or charter operations. Commercial pilots have more advanced training and experience compared to private or sport pilots.",
      opened: false
    },
    {
      question: "How to become a commercial pilot?",
      answer: "To become a commercial pilot, you typically need to follow these steps: \n\na. Obtain a private pilot license. \n\nb. Build flight experience, often requiring a minimum of 250 flight hours. \n\nc. Complete additional training to meet the commercial pilot certification requirements. \n\nd. Pass a written knowledge test and a practical flight test. \n\ne. Obtain a Class II medical certificate. \n\nf. Apply for and receive your commercial pilot certificate.",
      opened: false
    },
    {
      question: "How long does it take to become a commercial pilot?",
      answer: "The time it takes to become a commercial pilot can vary widely, but it often takes several years. The duration depends on factors like your availability for training, the flight school you choose, and the specific pathway you follow.",
      opened: false
    },
    {
      question: "How much do commercial pilots make?",
      answer: "Commercial pilot salaries can vary significantly depending on factors such as the type of aircraft flown, the employer, experience, and location. On average, commercial pilots in the United States earn a median annual salary in the range of $60,000 to $80,000 or more.",
      opened: false
    },
    {
      question: "How many flight hours to become a commercial pilot?",
      answer: "To qualify for a commercial pilot certificate in the United States, you typically need a minimum of 250 total flight hours, including a specified number of hours in various categories of flight (e.g., solo, cross-country, night, etc.).",
      opened: false
    },
    {
      question: "What is a Part 61 Commercial Pilots Course?",
      answer: "<b>A Part 61 flight training program requires that students obtain a Private Pilot certificate, Instrument rating, and meet the requirements to take a Commercial (usually Single Engine Land) exam – which requires a minimum of 250 hours.</b> \n\nPart 61 flight training offers more flexibility, as students can attend part-time as their schedule allows. There is no specific training program, and this unstructured approach allows a highly personalized training program to directly meet the specific student’s needs. \n\nAt the end of the course, students who are looking to obtain their Airline Transport Pilot (ATP) license will, once they have obtained their SEL COMM certificate, will generally obtain a Multi-Engine Land (MEL) add-on.",
      opened: false
    },
    {
      question: "What is a Part 141 Commercial Pilots Course?",
      answer: "A Part 141 course can only be offered by FAA approved schools, and also requires that students obtain a Private Pilot certificate, Instrument rating, and meet the requirements to take a Commercial (usually Single Engine Land) exam – which requires a minimum of 190 hours. The courses typically are compressed and are ‘linear’ in their completion requirements – i.e. lesson 3 has to be fully completed prior to starting lesson 4. \n\nA Part 141 course is highly structured, and can be the preferred choice for students who want to obtain their SEL COMM certificate in the shortest possible timeframe.",
      opened: false
    },
    {
      question: "Can I Mix and Match Part 61 and 141 courses?",
      answer: "In order to qualify for a Part 141 SEL COMM, you are required to take the part 141 Instrument rating and SEL COMM courses. Students can take a Part 61 Private Pilot and then switch to a Part 141 Instrument course. Students who take a Part 61 Instrument rating are NOT eligible for a Part 141 COMM certificate.",
      opened: false
    },
    {
      question: "Why do I want to take a Part 141 Course?",
      answer: "The biggest differentiator between the Part 61 and 141 COMM rating is the reduction in the number of hours – Part 61 requires 250 hours, while Part 141 COMM only needs 190 hours; This directly translates to less time and money.",
      opened: false
    },
    {
      question: "Are there any differences between a Part 61 and Part 141 Commercial License?",
      answer: "No – both licenses provide students with an FAA COMM license.",
      opened: false
    }
  ],
  "multi-engine-rating": [
    {
      question: "How to get multi engine rating?",
      answer: "A multi-engine rating is an additional qualification that allows pilots to operate aircraft with multiple engines. To obtain this rating, a pilot typically needs to undergo training and pass a checkride in a multi-engine aircraft. This rating is often sought by those pursuing careers in aviation, especially for jobs where multi-engine aircraft are used.",
      opened: false
    },
    {
      question: "What Materials should I have for this course?",
      answer: "Each course offered requires specific resources that are referenced. Since Aviation has such a high cost, we make every attempt to keep book purchases to a minimum. \n\nEach course of study and their corresponding modules have reading materials and video resources that must be read or watched. If it is a necessity for the course, it will be listed in the Course Resources Module. Students will be sent a Computer Based Training (CBT) link and a training manual, and the CBT course has various tests and quizzes associated with it. We expect students to have finished the CBT and Training References Manual tests prior to arriving for their first class. This pre-study is critical, especially if students have enrolled in the accelerated class. \n\n<b>If students have not completed and passed their pre-study quizzes, then they are unable to be considered an accelerated student. It is likely that some students may need additional instruction not covered in the base cost of the course.</b>",
      opened: false
    },
    {
      question: "What if I have a question, problem or error that needs an instructor’s attention?",
      answer: "If students have questions about the syllabus or training documents, they should email the Chief Pilot. If a question is complex and requires a conversation, then every effort should be made to schedule the meeting via Zoom before the session starts.",
      opened: false
    },
    {
      question: "Can I drop by with questions?",
      answer: "It is best to send your instructor a note via e-mail first. That way you can schedule an appointment that works for both of you. If you decide to drop by the office without an appointment, expect the instructor to be unavailable. They may be teaching a class or preparing a lesson for that day. If you catch them in, they will be more than happy to address your concerns.",
      opened: false
    },
    {
      question: "Are deposits required for training?",
      answer: "Yes, we require a minimum of $1,000 as a deposit to reserve your scheduled training dates. The remainder of the funds are due and payable one (1) week prior to the actual class start date",
      opened: false
    },
    {
      question: "Is the deposit refundable?",
      answer: "No. The $1,000 deposit is non-refundable. Once training has started, any refund will be calculated based on standard rates.",
      opened: false
    },
    {
      question: "What form of payment do we accept?",
      answer: "Cash, Wire or ACH are the preferred payment methods. We will accept credit card charges for the initial deposit. We do not accept online currencies such as BitCoin",
      opened: false
    },
    {
      question: "Are there any surcharges or hidden fees?",
      answer: "There are no hidden fees if the student purchases the “package” price. Some students prefer to “pay as you go” – and any charges are applied immediately after the lesson has been completed \n\n<b>NOTE</b> – all accelerated course students <b>are required</b> to purchase the twin training package.",
      opened: false
    },
    {
      question: "Does the package price cover all training, regardless as to how long it may take?",
      answer: "If the student training exceeds <b>either</b> the instructor or flight time listed in the package price, students will be billed the addition fees at the standard rental / instruction rates.",
      opened: false
    }
  ],
  "flight-instructor": [
    {
      question: "What is CFI?",
      answer: "A Certified Flight Instructor (CFI) is a pilot who has met the necessary qualifications and holds a CFI certificate, which allows them to provide flight instruction to student pilots. CFIs play a crucial role in training and mentoring aspiring pilots, helping them gain the skills and knowledge required to become safe and competent aviators.",
      opened: false
    }
  ],
  "international-students": [],
  "dgca-india": []
});
const css = {
  code: ".faqs.svelte-tzpzxw.svelte-tzpzxw{padding:10rem;background-color:#0e76bc;display:flex;flex-direction:column;gap:3rem}@media screen and (max-width: 1280px){.faqs.svelte-tzpzxw.svelte-tzpzxw{padding:4rem 2rem}}.faqs__title.svelte-tzpzxw.svelte-tzpzxw{font-size:3rem;text-transform:uppercase}.faqs__array.svelte-tzpzxw.svelte-tzpzxw{display:flex;flex-direction:column;gap:3rem}.faqs__array--iterable.svelte-tzpzxw.svelte-tzpzxw{border:0.3rem solid #fff;border-radius:2rem;padding:1.4rem 2rem}.faqs__array--iterable.svelte-tzpzxw.svelte-tzpzxw:hover{background-color:#2683c2;cursor:pointer}.iterable__top.svelte-tzpzxw.svelte-tzpzxw{display:flex;justify-content:space-between;align-items:center}.iterable__top--title.svelte-tzpzxw.svelte-tzpzxw{font-size:2rem;font-weight:500}.iterable__top--icon.svelte-tzpzxw.svelte-tzpzxw{font-size:3rem;transition:transform 0.25s ease-in-out}.iterable__answer.svelte-tzpzxw.svelte-tzpzxw{opacity:0;max-height:min-content;margin:0;line-height:normal;font-style:italic;font-size:0;transition:all 0.5s ease-in-out}.clicked.svelte-tzpzxw .iterable__top--icon.svelte-tzpzxw{transform:rotate(45deg)}.clicked.svelte-tzpzxw .iterable__answer.svelte-tzpzxw{opacity:1;margin:1.3rem;font-size:1.8rem}",
  map: null
};
const FAQs = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $page, $$unsubscribe_page;
  $$unsubscribe_page = subscribe(page, (value) => $page = value);
  let allFaqs;
  let renderedFaqs;
  faqs.subscribe((value) => {
    allFaqs = value;
  });
  $$result.css.add(css);
  renderedFaqs = allFaqs[$page.url.pathname.split("/").slice(-1)[0]];
  $$unsubscribe_page();
  return `${renderedFaqs[0] ? `<article class="faqs svelte-tzpzxw"><h2 class="faqs__title svelte-tzpzxw" data-svelte-h="svelte-879sxu">Frequently asked questions</h2> <div class="faqs__array svelte-tzpzxw">  ${each(renderedFaqs, ({ question, answer, opened }) => {
    return `<section class="${["faqs__array--iterable svelte-tzpzxw", opened ? "clicked" : ""].join(" ").trim()}"><div class="iterable__top svelte-tzpzxw"><h3 class="iterable__top--title svelte-tzpzxw">${escape(question)}</h3> <div class="iterable__top--icon svelte-tzpzxw">${validate_component(Plus, "Plus").$$render($$result, {}, {}, {})}</div></div> <div class="iterable__answer svelte-tzpzxw"><p class="iterable__answer--p"><!-- HTML_TAG_START -->${answer}<!-- HTML_TAG_END --></p></div> </section>`;
  })}</div></article>` : ``}`;
});
const Layout = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  return `<div class="service">${slots.default ? slots.default({}) : ``} ${validate_component(Programs, "Programs").$$render($$result, {}, {}, {})} ${validate_component(RentalRates, "RentalRates").$$render($$result, {}, {}, {})} ${validate_component(DiscoveryFlight, "DiscoveryFlight").$$render($$result, {}, {}, {})} ${validate_component(Financing, "Financing").$$render($$result, {}, {}, {})} ${validate_component(FAQs, "FAQs").$$render($$result, {}, {}, {})} ${validate_component(Reviews, "Reviews").$$render($$result, {}, {}, {})} ${validate_component(Contact, "Contact").$$render($$result, {}, {}, {})}</div>`;
});

export { Layout as default };
//# sourceMappingURL=_layout.svelte-bcd380a9.js.map
