import { c as create_ssr_component, v as validate_component, d as add_styles } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { R as Roadmap } from './Roadmap-b89b5076.js';
import { P as Prerequisites } from './Prerequisites-09460ce9.js';
import { I as Image } from './Image-c986cba7.js';
import { B as Button } from './Button-b4fad8e7.js';
import { B as BookOpenPageVariant } from './BookOpenPageVariant-8d667132.js';
import { A as AirplaneTakeoff } from './AirplaneTakeoff-bb9ec5c6.js';
import { C as CheckDecagram } from './CheckDecagram-6513be28.js';
import { A as AirplaneClock } from './AirplaneClock-cb0f1431.js';

const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/g2g.1d8c8acf.avif 1x, /_app/immutable/assets/g2g.a1ec46bf.avif 2x",
    webp: "/_app/immutable/assets/g2g.78b36f20.webp 1x, /_app/immutable/assets/g2g.c7767c1f.webp 2x",
    jpeg: "/_app/immutable/assets/g2g.c7931754.jpg 1x, /_app/immutable/assets/g2g.35d47941.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/g2g.35d47941.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src1 = {
  sources: {
    avif: "/_app/immutable/assets/cessna_rotate.f169c44e.avif 1x, /_app/immutable/assets/cessna_rotate.3787819b.avif 2x",
    webp: "/_app/immutable/assets/cessna_rotate.67dd2bb3.webp 1x, /_app/immutable/assets/cessna_rotate.b966765b.webp 2x",
    jpeg: "/_app/immutable/assets/cessna_rotate.e9698fb8.jpg 1x, /_app/immutable/assets/cessna_rotate.c9d771eb.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/cessna_rotate.c9d771eb.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src2 = {
  sources: {
    avif: "/_app/immutable/assets/rob_checkride.c1531e65.avif 1x, /_app/immutable/assets/rob_checkride.c08d308c.avif 2x",
    webp: "/_app/immutable/assets/rob_checkride.987efe44.webp 1x, /_app/immutable/assets/rob_checkride.35bf3842.webp 2x",
    jpeg: "/_app/immutable/assets/rob_checkride.f5a178a8.jpg 1x, /_app/immutable/assets/rob_checkride.f0939189.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/rob_checkride.f0939189.jpg",
    w: 6e3,
    h: 4e3
  }
};
const image_src = {
  sources: {
    avif: "/_app/immutable/assets/lets_go.b614ffba.avif 1x, /_app/immutable/assets/lets_go.8b219c21.avif 2x",
    webp: "/_app/immutable/assets/lets_go.dad10e38.webp 1x, /_app/immutable/assets/lets_go.381d6a38.webp 2x",
    jpeg: "/_app/immutable/assets/lets_go.65b7732b.jpg 1x, /_app/immutable/assets/lets_go.ab01b799.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/lets_go.ab01b799.jpg",
    w: 6e3,
    h: 4e3
  }
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let stages = [
    [
      {
        label: "Time building",
        icon: AirplaneClock
      },
      {
        label: "Commercial Pilot Training",
        icon: BookOpenPageVariant
      },
      {
        label: "Commercial Pilot Checkride",
        icon: AirplaneTakeoff
      },
      {
        label: "Commercial Pilot Achieved",
        icon: CheckDecagram
      }
    ]
  ];
  let prerequisites = {
    eligibility: [
      "Are over 18 years of age",
      "Proficient in the English Language",
      "Hold at least a private pilot certificate",
      "Receive the required training and a logbook endorsement from an authorized instructor",
      "Pass the required knowledge test on the aeronautical knowledge areas",
      "Meet the aeronautical experience requirements that apply to the aircraft category and class rating sought",
      "Pass the required practical test",
      "Comply with the federal aviation regulations that apply to commercial flight"
    ],
    proficiency: [
      "Preflight preparation",
      "Preflight procedures",
      "Airport operations",
      "Takeoffs, landings, and go-arounds",
      "Performance maneuvers",
      "Ground reference maneuvers",
      "Navigation",
      "Slow flight and stalls",
      "Emergency operations",
      "High-altitude operations",
      "Post-flight procedures"
    ],
    experience: [
      "250 hours of flight time",
      "100 hours, of which 50 hours must be in airplanes",
      "100 hours of pilot-in-command flight time which includes at least 50 hours in cross-country flight",
      "20 hours of training",
      "10 hours of instrument training using a view-limiting device",
      "10 hours of training in a complex airplane, a turbine-powered airplane, or a technically advanced airplane (TAA) or any combination thereof",
      "One 2-hour cross country flight in daytime conditions that consists of a total straight-line distance of more than 100 nautical miles",
      "One 2-hour cross country flight in nighttime conditions that consists of a total straight-line distance of more than 100 nautical miles",
      "3 hours with an instructor in preparation for the practical test within the preceding 2 calendar months",
      "10 hours of solo time or 10 hours of flight performing the duties of pilot in command with an instructor",
      "One cross-country flight of not less than 300 nautical miles total distance, with landings at a minimum of three points, one of which is a straight-line distance of at least 250 nautical miles",
      "5 hours in night VFR conditions with 10 takeoffs and 10 landings at an airport with an operating control tower"
    ]
  };
  return `${$$result.head += `<!-- HEAD_svelte-hyy7ep_START -->${$$result.title = `<title>Commercial Pilot | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation commercial pilot training"><!-- HEAD_svelte-hyy7ep_END -->`, ""} ${validate_component(Hero, "Hero").$$render(
    $$result,
    {
      alt: "",
      src: hero_src,
      top: 0,
      translate: "-50%, 0"
    },
    {},
    {
      main: () => {
        return `<div slot="main" data-svelte-h="svelte-1qaz7zj">Obtaining your Commercial Pilot License requires students dedicating their time and skills
        to achieve a professional certification. Obtaining a commercial pilots license involves
        accumulating a specific number of flight hours and mastering several professional maneuvers
        and techniques. Once a student has earned this certification, they are eligible for various
        career possibilities such as flight instruction, aerial photography, cargo transport,
        charter operations, banner towing, corporate flight and more.</div>`;
      },
      titleTwo: () => {
        return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-16bqbb0">Pilot Program</span>`;
      },
      titleOne: () => {
        return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-yu4rp2">Commercial</span>`;
      }
    }
  )} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "Cessna 172 rotating",
          src: content_src1
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-sskq7y">The initial stage of your journey to becoming a commercial pilot is obtaining your
            Private Pilot Certificate. Once you have obtained your Private Pilot License with enough
            hours and training in high performance maneuvers you can work towards your commercial
            pilot license which allows you to transport persons and property for hire. In this
            course you will learn to perfect in flight and ground reference maneuvers that build
            your confidence and proficiency as a professional pilot. It is highly advisable that you
            obtain your instrument rating before beginning your commercial pilots training to avoid
            significant limitations on your privilege. The type of aircraft used in this course are
            Piper and Cessna aircraft, some of which include full-glass flight decks.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1vy11x7">Course Description</span>`;
          }
        }
      )} ${validate_component(Roadmap, "Roadmap").$$render($$result, { stages }, {}, {})} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main">The minimum commercial pilot age limit is 18 years of age. In order to begin your
            training you must be able to read, write, speak and understand English proficiently.
            Before you do your check-ride, you&#39;ll need to obtain a medical certificate (second class
            or higher) from an FAA approved aviation medical examiner (AME) in the United States.
            You will also need to show proof of U.S. Citizenship or TSA approval (which requires a
            valid and current US visa) as well as your private pilot certificate and knowledge test
            results.
            <br> <br> ${validate_component(Button, "Button").$$render($$result, { color: "blue", href: "/contact-us" }, {}, {
            default: () => {
              return `Book Now`;
            }
          })}</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-17oidz4">What Do You Need to Start?</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "Commercial pilot checkride",
          src: content_src2
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-k4xgje">A check-ride is an essential part of the pilot certification process that includes both
            a flight test and an oral exam. During a check-ride, a designated pilot examiner (DPE)
            assesses the pilot&#39;s ability to operate an aircraft safely and proficiently. The
            examination covers various aspects, including flight maneuvers, navigation, emergency
            procedures, communication skills, and a thorough understanding of aviation regulations.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-cuvss2">Checkride Information</span>`;
          }
        }
      )} ${validate_component(Prerequisites, "Prerequisites").$$render($$result, { prerequisites }, {}, {})} ${validate_component(Image, "Image").$$render(
        $$result,
        {
          alt: "Piper 100i taxiing",
          src: image_src
        },
        {},
        {}
      )}`;
    }
  })}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-17f23893.js.map
