import { c as create_ssr_component, v as validate_component, d as add_styles } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { R as Roadmap } from './Roadmap-b89b5076.js';
import { P as Prerequisites } from './Prerequisites-09460ce9.js';
import { I as Image } from './Image-c986cba7.js';
import { A as AccountCowboyHatOutline } from './AccountCowboyHatOutline-388465b7.js';
import { B as BookOpenPageVariant } from './BookOpenPageVariant-8d667132.js';
import { A as AirplaneTakeoff } from './AirplaneTakeoff-bb9ec5c6.js';
import { C as CheckDecagram } from './CheckDecagram-6513be28.js';

const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/ramp.c91ddee6.avif 1x, /_app/immutable/assets/ramp.f84aa708.avif 2x",
    webp: "/_app/immutable/assets/ramp.f7bf9547.webp 1x, /_app/immutable/assets/ramp.8d31bdaa.webp 2x",
    jpeg: "/_app/immutable/assets/ramp.04ab7472.jpg 1x, /_app/immutable/assets/ramp.212c6b7a.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/ramp.212c6b7a.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src1 = {
  sources: {
    avif: "/_app/immutable/assets/sump.8360d064.avif 1x, /_app/immutable/assets/sump.19ee9aab.avif 2x",
    webp: "/_app/immutable/assets/sump.710eb830.webp 1x, /_app/immutable/assets/sump.3d0d99cc.webp 2x",
    jpeg: "/_app/immutable/assets/sump.223e1102.jpg 1x, /_app/immutable/assets/sump.676ebdbc.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/sump.676ebdbc.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src2 = {
  sources: {
    avif: "/_app/immutable/assets/wings.14cb1044.avif 1x, /_app/immutable/assets/wings.6d9a1e91.avif 2x",
    webp: "/_app/immutable/assets/wings.cbef6c7f.webp 1x, /_app/immutable/assets/wings.f6acaffa.webp 2x",
    jpeg: "/_app/immutable/assets/wings.9444f677.jpg 1x, /_app/immutable/assets/wings.2c258578.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/wings.2c258578.jpg",
    w: 6e3,
    h: 4e3
  }
};
const image_src = {
  sources: {
    avif: "/_app/immutable/assets/student_with_certificate.8fc92aac.avif 1x, /_app/immutable/assets/student_with_certificate.7c702a77.avif 2x",
    webp: "/_app/immutable/assets/student_with_certificate.e6e44f23.webp 1x, /_app/immutable/assets/student_with_certificate.7f95efe3.webp 2x",
    jpeg: "/_app/immutable/assets/student_with_certificate.77579114.jpg 1x, /_app/immutable/assets/student_with_certificate.6509dd06.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/student_with_certificate.6509dd06.jpg",
    w: 6e3,
    h: 4e3
  }
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let stages = [
    [
      {
        label: "Orientation / Discover flight",
        icon: AccountCowboyHatOutline
      },
      {
        label: "Private Pilot Training",
        icon: BookOpenPageVariant
      },
      {
        label: "Private Pilot Checkride",
        icon: AirplaneTakeoff
      },
      {
        label: "Private Pilot Acheived",
        icon: CheckDecagram
      }
    ]
  ];
  let prerequisites = {
    eligibility: [
      "Be at least 17 years old",
      "Be able to read, speak, write, and understand the English language proficiently",
      "Hold a U.S. student pilot, sport pilot, or recreational pilot certificate",
      "Receive ground training or home study the required aeronautical knowledge",
      "Have an instructor certifying that you are prepared for the required knowledge test",
      "Have an instructor certify that you are prepared for the practical test",
      "Pass the knowledge test on aeronautical knowledge",
      "Have received flight training from a certified flight instructor in areas of operation (listed below)",
      "Pass the practical test"
    ],
    proficiency: [
      "Preflight preparation",
      "Preflight procedures",
      "Airport operations",
      "Takeoffs, landings, and go-arounds",
      "Performance maneuvers",
      "Ground reference maneuvers",
      "Navigation",
      "Slow flight and stalls",
      "Basic instrument maneuvers",
      "Emergency operations",
      "Night operations",
      "Post-flight procedures"
    ],
    experience: [
      "At least 40 total hours of flying",
      "At least 20 hours of flight training",
      "At least 10 hours of solo flight",
      "At least 5 hours of solo cross-country flying",
      "One solo cross country flight of 150 nautical miles total distance, with full-stop landings at three points, and one segment of the flight consisting of a straight-line distance of more than 50 nautical miles between the takeoff and landing locations",
      "3 takeoffs and landings involving flight in the airport traffic pattern with an operational control tower",
      "At least 3 hours of cross-country training",
      "At least 3 hours of night flight training",
      "One cross-country over 100nm",
      "10 takeoffs and landings involving flight in the airport traffic pattern",
      "At least 3 hours of simulated instrument training"
    ]
  };
  return `${$$result.head += `<!-- HEAD_svelte-1b88ah_START -->${$$result.title = `<title>Private Pilot | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation private pilot training"><!-- HEAD_svelte-1b88ah_END -->`, ""} ${validate_component(Hero, "Hero").$$render(
    $$result,
    {
      alt: "",
      src: hero_src,
      top: 0,
      translate: "-50%, 0"
    },
    {},
    {
      main: () => {
        return `<div slot="main" data-svelte-h="svelte-l3rqdi">Earning your Private Pilot&#39;s License allows you to operate a single-engine aircraft
        following visual flight rules (VFR), which require a minimum visibility of three miles and
        also permits nighttime flying. Carrying passengers is permitted, however you are not allowed
        to receive compensation for your services. You are permitted to share the operational costs
        with your passengers.</div>`;
      },
      titleTwo: () => {
        return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-16bqbb0">Pilot Program</span>`;
      },
      titleOne: () => {
        return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-90jvj9">Private</span>`;
      }
    }
  )} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "Pilots sumping fuel tanks",
          src: content_src1
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-1l3ay06">Our Private Pilot Training course includes ground and flight instruction in which you
            are able to complete at your own pace, so you can be on your way to flying your own
            airplane in practically no time. You will be training with some of our finest
            instructors, using high quality Piper and Cessna aircraft, some of which include full
            glass flight decks. No prior flight experience required.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1vy11x7">Course Description</span>`;
          }
        }
      )} ${validate_component(Roadmap, "Roadmap").$$render($$result, { stages }, {}, {})} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-go5p73">In order to begin your training you must be able to read, write, speak and understand
            English proficiently. Before you can fly, you&#39;ll need to pass your medical exam and
            acquire a medical certificate from an FAA approved aviation medical examiner (AME). You
            will also need to show proof of U.S. Citizenship or TSA approval as well as your student
            pilot certificate.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-17oidz4">What Do You Need to Start?</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "Pilot holding wings",
          src: content_src2
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-k4xgje">A check-ride is an essential part of the pilot certification process that includes both
            a flight test and an oral exam. During a check-ride, a designated pilot examiner (DPE)
            assesses the pilot&#39;s ability to operate an aircraft safely and proficiently. The
            examination covers various aspects, including flight maneuvers, navigation, emergency
            procedures, communication skills, and a thorough understanding of aviation regulations.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-cuvss2">Checkride Information</span>`;
          }
        }
      )} ${validate_component(Prerequisites, "Prerequisites").$$render($$result, { prerequisites }, {}, {})} ${validate_component(Image, "Image").$$render(
        $$result,
        {
          alt: "Student pilot with temporary airman certificate",
          src: image_src
        },
        {},
        {}
      )}`;
    }
  })}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-49f794b7.js.map
