import { c as create_ssr_component, v as validate_component, d as add_styles, b as add_attribute, o as onDestroy, e as escape, f as each } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { R as Roadmap } from './Roadmap-b89b5076.js';
import { E as Equal, I as Included } from './Equal-6ddfaeca.js';
import { B as Button } from './Button-b4fad8e7.js';
import { I as IconCard, E as EmailFast } from './EmailFast-de608afa.js';
import { P as Phone } from './Phone-7816fc1a.js';
import { B as BookOpenPageVariant } from './BookOpenPageVariant-8d667132.js';
import { C as CastEducation } from './CastEducation-a03ba997.js';
import { T as Turbine } from './Turbine-82ea90b2.js';
import { F as FridgeMagnet, P as Plus } from './Plus-6453516c.js';

const css$4 = {
  code: ".video-container.svelte-1pv45ja.svelte-1pv45ja{position:relative;padding-bottom:calc(9 / 16 * 100%);height:0;overflow:hidden}.video-container.svelte-1pv45ja iframe.svelte-1pv45ja{position:absolute;top:0;left:0;width:100%;height:100%;border-radius:1rem}",
  map: null
};
const YoutubeEmbed = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let height;
  let { videoId } = $$props;
  let { width = 560 } = $$props;
  let { title } = $$props;
  if ($$props.videoId === void 0 && $$bindings.videoId && videoId !== void 0)
    $$bindings.videoId(videoId);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  $$result.css.add(css$4);
  height = width / (16 / 9);
  return ` <div class="video-container svelte-1pv45ja"> <iframe${add_attribute("title", title, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("src", `https://www.youtube.com/embed/${videoId}`, 0)} frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen class="svelte-1pv45ja"></iframe> </div>`;
});
const css$3 = {
  code: ".reviews.svelte-16880zt{display:flex;justify-content:space-between;gap:10vw;background-color:#f36d21;padding:10rem;overflow:hidden}@media screen and (max-width: 1280px){.reviews.svelte-16880zt{flex-direction:column;gap:6rem;padding:4rem 2rem}}.reviews__text--title.svelte-16880zt{font-family:'REM Variable';font-size:4.4rem;text-transform:uppercase}@media screen and (max-width: 1024px){.reviews__text--title.svelte-16880zt{font-size:3rem}}.reviews__text--array.svelte-16880zt{display:flex;flex-direction:column;gap:3rem}.array__iterable.svelte-16880zt{display:flex;flex-direction:column;gap:2rem;padding:3.6rem;background-color:#fff;border-radius:2rem}.array__iterable--p.svelte-16880zt{font-size:1.8rem;font-style:italic;line-height:normal;color:#15181c}.array__iterable--span.svelte-16880zt{font-size:1.6rem;font-weight:500;color:#000}.seperator.svelte-16880zt{border:0.1rem solid rgba(255,255,255,0.5);margin:3rem 0}",
  map: null
};
const Reviews = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css$3);
  return `<article class="reviews svelte-16880zt" data-svelte-h="svelte-1erxmvv"><section class="reviews__text"><h2 class="reviews__text--title svelte-16880zt">Hear from our clients
			<hr class="seperator svelte-16880zt"></h2> <div class="reviews__text--array svelte-16880zt"><section class="array__iterable svelte-16880zt"><p class="array__iterable--p svelte-16880zt">“I’m glad I looked around for options before deciding on a place for flight
					training, otherwise I would’ve missed this place. I just received my PPL at
					First Landings and plan on furthering my pilot career here. Everyone has been
					fantastic and every instructor I flew with had helpful and constructive feedback
					for my growth. My main instructor Tim has been awesome and super patient with me
					throughout my training. Very comfortable and supportive place for learning to
					fly.
					<br> <br>
					Part 2: Instrument Rating with Anthony
					<br> <br>
					I just passed my Instrument checkride and I couldn&#39;t have done it without my wonderful
					instructor Anthony. He&#39;s very knowledgeable, a great teacher, and knows how to make
					learning an enjoyable time. It was a fun and challenging experience that has made
					me a better pilot. I am excited to start working on my Commercial License here and
					to keep furthering my pilot career.“</p> <span class="array__iterable--span svelte-16880zt">- Joshua Timmer</span></section> <section class="array__iterable svelte-16880zt"><p class="array__iterable--p svelte-16880zt">“This has been my flight school for a little over a year now and it’s been
					fantastic. The staff is extremely professional and the airplanes are in
					excellent like new condition. My instructor Tim Bohr is an excellent CFI and I’m
					extremely grateful to him for giving me the gift of flight. He puts his heart
					into the development of his students and it shows. Another thing is the
					location. The practice area is right behind the school and the runway is right
					in front of it. So you don’t burn time getting into you lesson. This saves a lot
					of money. I highly recommend First Landings for any stage of flight training!“</p> <span class="array__iterable--span svelte-16880zt">- Matthew Rammig</span></section> <section class="array__iterable svelte-16880zt"><p class="array__iterable--p svelte-16880zt">“I came across First Landings when I was looking for a Job as a flight
					instructor as an international student from India. There were a lot of
					challenges for me because I wasn&#39;t aware of how things work in the USA,
					especially in the job world in aviation. I interviewed with First Landings &amp; got
					hired. It was one of the most amazing days of my life. Everybody at First
					Landing was welcoming &amp; very helpful. As a foreigner, I felt so relaxed there &amp;
					learned from the best, Captain James Willaim who is the chief flight instructor.
					He is one of the most humble pilots I have ever met. I idolize him. Everybody
					else on the management team is awesome too. As soon as you enter the First
					landings, you will feel at ease. They have a very supportive environment &amp; that
					matters because it makes you feel respected. The most important thing about them
					is that they don&#39;t compromise on quality training. Best Aircrafts with excellent
					maintenance. They are very dedicated to students. Adam &amp; Pete make sure there is
					transparency in finances &amp; if you are an international student you will be
					guided &amp; helped properly with your visa issues as well. Caitlyn is super-helpful
					&amp; she can make you smile in seconds. Highly recommend First Landings for your
					aviation career. Top-notch flight school in the entire USA.“</p> <span class="array__iterable--span svelte-16880zt">- Neha Chaudhary</span></section></div></section> </article>`;
});
const css$2 = {
  code: ".masonry.svelte-c22sv6{position:relative;width:100%;height:auto}",
  map: null
};
const Masonry = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { gap = "16px" } = $$props;
  let { maxColumns = 3 } = $$props;
  let container;
  onDestroy(() => {
  });
  if ($$props.gap === void 0 && $$bindings.gap && gap !== void 0)
    $$bindings.gap(gap);
  if ($$props.maxColumns === void 0 && $$bindings.maxColumns && maxColumns !== void 0)
    $$bindings.maxColumns(maxColumns);
  $$result.css.add(css$2);
  return `  <div class="masonry svelte-c22sv6" style="${"gap: " + escape(gap, true) + ";"}"${add_attribute("this", container, 0)}>${slots.default ? slots.default({}) : ``} </div>`;
});
const css$1 = {
  code: ".neha.svelte-1vplh6q.svelte-1vplh6q{display:flex;align-items:center;gap:4rem}@media screen and (max-width: 1536px){.neha.svelte-1vplh6q.svelte-1vplh6q{flex-direction:column;align-items:center}}.neha__contact.svelte-1vplh6q.svelte-1vplh6q{display:flex;flex-direction:column;align-items:center;gap:2rem}.neha__contact--img.svelte-1vplh6q.svelte-1vplh6q{width:100%;height:auto;object-fit:cover;position:absolute}.img__wrapper.svelte-1vplh6q.svelte-1vplh6q{position:relative;width:20rem;height:20rem;border-radius:50rem;overflow:hidden}.icon-cards.svelte-1vplh6q.svelte-1vplh6q{display:flex;padding:0 10rem;flex-wrap:wrap;justify-content:center;gap:7.5rem}@media(max-width: 800px){.icon-cards.svelte-1vplh6q.svelte-1vplh6q{flex-direction:column;padding:5rem 0.5rem;gap:2.5rem}}.content.svelte-1vplh6q.svelte-1vplh6q{font-size:1.6rem}.content.svelte-1vplh6q p.svelte-1vplh6q{text-align:center;line-height:normal}",
  map: null
};
const NehaContact = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let cards = [
    {
      icon: Phone,
      title: "Call",
      content: [
        "<a href='tel:+91-965-002-9910' style='text-decoration: none; color: white;'>+91 (965) 002-9910</a> "
      ]
      // "Mobile: (+1) 0428 371 684 ",
    },
    {
      icon: EmailFast,
      title: "Email",
      content: [
        "<a href='mailto:nehach.fla@gmail.com' style='text-decoration: none; color: white;'>nehach.fla@gmail.com</a>"
      ]
      // "info@firstlandings.com"
    }
  ];
  $$result.css.add(css$1);
  return `${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" class="neha svelte-1vplh6q" data-svelte-h="svelte-ckk4m8"><div class="neha__text">My name is Neha Chaudhary, and I was born &amp; raised in the state of Uttarakhand,
				India. I’m a mechanical engineer &amp; a trained professional in human resource
				management, specializing in workplace &amp; retention policies.
				<br> <br>
				I was 10 years old when I fell in love with aviation and wanted to become a pilot and
				see the world. Currently, I’m a US FAA Certified Flight &amp; Ground Instructor. I have a
				passion for teaching which came from working at a non-profit organization, and as I continue
				to grow &amp; learn in my aviation career, I feel more inclined towards helping students
				achieve their dreams of becoming a professional pilot.
				<br> <br>
				In recent years, there has been a significant increase in the number of people seeking
				pilot training programs. The allure of becoming a pilot and the opportunities that come
				with it have made this profession increasingly popular among students from all over the
				world. However, steering the intricacies of pilot training as an international student
				can be a daunting task. From obtaining the necessary qualifications and certifications
				to navigating visa requirements and language barriers, there are many factors to consider
				when embarking on this path. Being an International student myself once, I understand
				the importance of quality training as well as the smooth transition needed while becoming
				accustomed to a completely foreign culture.
				<br> <br>
				My goals are straightforward- I will be working with the students &amp; instructors, personally
				tracking each student&#39;s performance, allowing me to provide mentorship throughout their
				courses, and ensuring timely resolutions of any issues that students may come across
				during their training. I trained at First Landings in Florida as a Flight Instructor,
				and I found a home away from home while pursuing my aviation career. I hope to make your
				pilot training experience as good as mine was, which was remarkable.</div> <div class="neha__contact svelte-1vplh6q"> <div class="img__wrapper svelte-1vplh6q"><picture><source${add_attribute("srcset", "/_app/immutable/assets/neha.a4935ac2.avif 540w, /_app/immutable/assets/neha.d029d83f.avif 768w, /_app/immutable/assets/neha.7793d1e6.avif 1080w, /_app/immutable/assets/neha.5be1ae84.avif 1242w", 0)} sizes="min(450px, 100%)" type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/neha.bfe9e4bb.webp 540w, /_app/immutable/assets/neha.2631d9d3.webp 768w, /_app/immutable/assets/neha.bc31ca4d.webp 1080w, /_app/immutable/assets/neha.15008057.webp 1242w", 0)} sizes="min(450px, 100%)" type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/neha.9b9067b5.jpg 540w, /_app/immutable/assets/neha.b9c6f1df.jpg 768w, /_app/immutable/assets/neha.096fb6a6.jpg 1080w, /_app/immutable/assets/neha.7959015c.jpg 1242w", 0)} sizes="min(450px, 100%)" type="image/jpeg"><img class="neha__contact--img svelte-1vplh6q" alt="" src="/_app/immutable/assets/neha.7959015c.jpg" width="1242" height="2208"></picture></div></div></div>`;
        },
        title: () => {
          return `<span slot="title" data-svelte-h="svelte-3225s9">Contact in India</span>`;
        }
      })}`;
    }
  })} <div class="icon-cards svelte-1vplh6q">${each(cards, (card) => {
    return `${validate_component(IconCard, "IconCard").$$render(
      $$result,
      {
        color: "orange",
        icon: card.icon,
        title: card.title
      },
      {},
      {
        default: () => {
          return `<div class="content svelte-1vplh6q">${each(card.content, (item) => {
            return `<p class="svelte-1vplh6q"><!-- HTML_TAG_START -->${item}<!-- HTML_TAG_END --></p>`;
          })}</div> `;
        }
      }
    )}`;
  })} </div>`;
});
const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/india.7393972d.avif 1x, /_app/immutable/assets/india.7015072e.avif 2x",
    webp: "/_app/immutable/assets/india.26b02968.webp 1x, /_app/immutable/assets/india.48896b53.webp 2x",
    jpeg: "/_app/immutable/assets/india.b4b7c001.jpg 1x, /_app/immutable/assets/india.ee975386.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/india.ee975386.jpg",
    w: 4856,
    h: 3216
  }
};
const css = {
  code: '.youtube__wrapper.svelte-10qvzzo{width:100%;display:grid;gap:2rem;align-items:center;grid-template-rows:auto auto}@media screen and (min-width: 1024px){.youtube__wrapper.svelte-10qvzzo{grid-template-columns:1fr 1fr;gap:4rem}}.youtube__supplement.svelte-10qvzzo{max-width:fit-content;margin:auto 0;padding:0;font-family:"Inter Variable";font-size:1.8rem;font-weight:400;line-height:normal;color:#15181c;text-align:left}@media screen and (min-width: 1280px){.content__card--compact.svelte-10qvzzo{display:grid;grid-template-columns:1fr 1fr;gap:4rem}}.topContainer.svelte-10qvzzo{display:flex;flex-direction:column}@media screen and (min-width: 1280px){.topContainer.svelte-10qvzzo{flex-direction:row}}.topContainer--dpes.svelte-10qvzzo{min-width:max-content;display:grid;grid-template-columns:1fr;gap:2rem}@media screen and (min-width: 1280px){.topContainer--dpes.svelte-10qvzzo{grid-template-columns:repeat(5, 1fr)}}.rates__card.svelte-10qvzzo{display:flex;flex-direction:column;align-items:center;gap:2.5rem;padding:2.5rem 0.5rem;border:0.3rem solid #f36d21;border-radius:1.5rem;background-color:#fff;color:#15181c}@media screen and (max-width: 1024px){.rates__card.svelte-10qvzzo{width:100%;max-width:none;margin:0 auto}}@media screen and (min-width: 2150px){.rates__card.svelte-10qvzzo{padding:3rem 3rem}}.rates__card--icon.svelte-10qvzzo{width:80%;display:flex;justify-content:center;align-items:center}.rates__card--values.svelte-10qvzzo{display:flex;flex-direction:column;align-items:center;gap:1rem;text-align:center;font-size:1.4rem;font-weight:600}@media screen and (min-width: 1536px){.rates__card--values.svelte-10qvzzo{font-size:1.5rem}}.margin.svelte-10qvzzo{margin-bottom:50%}@media screen and (max-width: 1280px){.margin.svelte-10qvzzo{margin:auto}}.adders.svelte-10qvzzo{margin:auto}.blue.svelte-10qvzzo{border:0.3rem solid #0e76bc}.values__price.svelte-10qvzzo{font-size:1.4rem;padding:0;margin:0}@media screen and (min-width: 1536px){.values__price.svelte-10qvzzo{font-size:1.5rem}}.separator.svelte-10qvzzo{border-top:0.1rem solid #0e76bc;width:90%}.masonry__item.svelte-10qvzzo{border-radius:2rem;overflow:hidden}.masonry__img.svelte-10qvzzo{width:100%;height:100%;object-fit:cover;box-sizing:border-box}.content.svelte-10qvzzo{display:flex;justify-content:space-between;align-items:center;padding:10rem 0;padding-left:8rem;gap:10vw}@media screen and (max-width: 1024px){.content.svelte-10qvzzo{padding:6rem 0;padding-left:2rem;flex-direction:column;gap:6rem}}.content__info.svelte-10qvzzo{max-width:80rem;min-width:40rem}@media screen and (max-width: 1024px){.content__info.svelte-10qvzzo{min-width:auto}}.content__info--title.svelte-10qvzzo{width:max-content;text-transform:uppercase;font-size:1.6rem;font-weight:normal;color:rgba(21,24,28,0.7)}.content__info--subtitle.svelte-10qvzzo{padding-top:1.3rem;text-transform:uppercase;font-size:3rem;color:#15181c}.content__info--p.svelte-10qvzzo{font-size:1.8rem;color:#2d3744;line-height:normal}.content__funnel.svelte-10qvzzo{display:flex;flex-direction:column;gap:2rem;max-width:80rem;background-color:#0e76bc;padding:4rem 3rem;border-radius:2rem 0 0 2rem;margin-left:auto}.content__funnel--title.svelte-10qvzzo{font-size:2.2rem;font-weight:500}.content__funnel--p.svelte-10qvzzo{font-size:1.8rem;line-height:normal}.content__funnel--button.svelte-10qvzzo{margin-left:auto}',
  map: null
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let stages = [
    [
      {
        label: "Private Pilot",
        icon: BookOpenPageVariant
      },
      {
        label: "Instrument Certificate",
        icon: CastEducation
      },
      {
        label: "Commercial Single Engine",
        icon: BookOpenPageVariant
      },
      {
        label: "Commercial Multi Engine",
        icon: Turbine
      }
    ]
  ];
  $$result.css.add(css);
  return `${$$result.head += `<!-- HEAD_svelte-14hec5r_START -->${$$result.title = `<title>DGCA India | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation DGCA India professional pilot program"><!-- HEAD_svelte-14hec5r_END -->`, ""} ${validate_component(Hero, "Hero").$$render($$result, { alt: "", src: hero_src }, {}, {
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-1bvz29i">International flight students coming from India will be immersed in a rich and diverse
		culture, encountering vibrant traditions and welcoming communities. <br><br>At our
		flight school, you will receive a comprehensive aviation education designed to train you as
		a professional Airline Transport Pilot, following the standards set by the Directorate
		General of Civil Aviation (DGCA). <br><br>No matter your background or origin, the only
		prerequisite is a strong desire to become a skilled and professional airline pilot.</div>`;
    },
    titleTwo: () => {
      return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-awicar">India</span>`;
    },
    titleOne: () => {
      return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-ilmrdp">DGCA</span>`;
    }
  })} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `<div class="youtube__wrapper svelte-10qvzzo">${validate_component(YoutubeEmbed, "YoutubeEmbed").$$render(
        $$result,
        {
          videoId: "lLi5xJ1omec?si=YRQp8A-PQPar6xhA",
          title: "test"
        },
        {},
        {}
      )} <p class="youtube__supplement svelte-10qvzzo" data-svelte-h="svelte-1kkm1ja">We&#39;re excited to share with you what First Landings has to offer. We welcome aspiring
			pilots from around the globe to our training programs. <br><br>In this video, you&#39;ll
			get a glimpse of our facilities, aircraft fleet, student accommodations, and the vibrant
			student life at First Landings. We hope it answers some of your questions and gives you
			a feel for what makes First Landings unique. After watching the video, explore our
			website for more comprehensive information. <br><br>We look forward to supporting
			you on your journey to becoming a professional pilot!</p></div> ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-zl4a3p">Many aspiring pilots want to learn to fly and obtain a commercial pilots license in the
			United States due to the low costs and world recognition of the US FAA license.
			<br> <br>
			The state of Florida is one of the best places in the US to learn to fly, as it is at sea
			level, has very mild winter weather, and students can train nearly every day all year.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1g337it">Florida is one of the best locations for training in the US</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-1j135uc">As a prospective student, what do we at First Landings Aviation, offer you that sets us
			apart?
			<br> <br> <ol><li><b>Longevity in Business</b> <br>
					We have been providing professional flight training since 2009.</li> <br> <li><b>Location</b> <br>
					We are located near Orlando in Central Florida at Apopka (X04), an uncontrolled airfield.
					Other flight schools are located in large Class C or D airports, which may require
					20 minutes-plus to taxi to an active runway before taking off – and then an additional
					5 to 10 minutes of flight to travel to the ‘practice area’. Our typical taxi time
					is less than 3 minutes, and our practice area is 1 minute from the airport.
					<br> <br>
					Why is important? In a 2 hour lesson, we spend nearly all the time flying, rather
					than 20% to 25% on the ground – this saves both time and money during the length
					of your training.</li> <br> <li><b>Modern Fleet of Aircraft</b> <br>
					First Landings has new Piper PA-28-181 Pilots 100i’s, Technically Advanced Aircraft
					(TAA), with Garmin G3X digital touch-screens and integrated digital avionics and
					autopilot, and the Tecnam P2006t multi-engine with duel digital G950’s and autopilots.</li> <br> <li><b>Standardized Training with our Certified Flight Instructors</b> <br>
					All instructors are required to undergo internal training to meet our company standards,
					which when coupled with our structured training and stage checks, results in the
					same standards and level of training from all our instructors.</li> <br> <li><b>Personalized Training Experience</b> <br>
					Our approach is to tailor training schedules for each student. Everybody learns in
					a different way, and rather than a regimented linear training schedule that requires
					the student to meet all of the standards or risk failing, we strive to understand
					what the underlying issues are, and work with students to develop strategies to help
					them overcome their various training obstacles.</li></ol></div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-15d0ghq">Why First Landings</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-f43pby"><ul class="content__card--compact svelte-10qvzzo"><div><li>Program Director, Aviation Sciences – Stephen F. Austin University
						<br> <ul><li>Curriculum developer for B.S. Aviation Sciences</li> <li>Curriculum Developer for Aviation Sciences Minor</li> <li>Curriculum Developer for online degree in Aviation Sciences</li> <li>Curriculum Developer for online degree in Aviation Sciences</li></ul></li> <br> <li>Boeing International Instructor Pilot/Training Program Manager
						<ul><li>767 Instructor for JAL/ANA</li> <li>777 Instructor for United, Southern, TAM, Singapore</li> <li>787 Instructor for United, American, Avianca, Singapore</li></ul></li> <br> <li>Captain, United Airlines (Ret.)
						<ul><li>Instructor Pilot – United Flight Training Center</li> <li>B767, 747, 747-400 International Pilot</li></ul></li></div> <div><li>Chief Human Factors and Systems Safety at Northrop-Grumman
						<ul><li>B-2 Project, SCAN Eagle Instructor</li></ul></li> <br> <li>Major, USAF/Reserve (Ret.)
						<ul><li>Instructor Pilot: T-38, A-10, KC-10</li></ul></li> <br> <li>Wing Chief of Standardization and Evaluation</li> <br> <li>Combat Veteran – Including but not limited to:
						<ul><li>Desert Shield</li> <li>Desert Storm</li> <li>Balkans War</li> <li>Somalia</li></ul></li> <br> <li>ATP – 737, 747, 747-400, 757, 767, 777, 787, DC-10, CFI, CFII, MEI,
						Commercial SE Land/Sea</li></div></ul></div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-lxifd8">James Williams – Chief Pilot First Landings Aviation</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1wbo2ds"><div class="topContainer--dpes svelte-10qvzzo"><section class="rates__card blue svelte-10qvzzo"><div class="rates__card--values svelte-10qvzzo"><h3 class="values__title--mobile">DPE Dave Hensch</h3></div></section> <section class="rates__card blue svelte-10qvzzo"><div class="rates__card--values svelte-10qvzzo"><h3 class="values__title--mobile">DPE Rob Galloway</h3></div></section> <section class="rates__card blue svelte-10qvzzo"><div class="rates__card--values svelte-10qvzzo"><h3 class="values__title--mobile">DPE Idalo Masi</h3></div></section> <section class="rates__card blue svelte-10qvzzo"><div class="rates__card--values svelte-10qvzzo"><h3 class="values__title--mobile">DPE Jay Smith</h3></div></section> <section class="rates__card blue svelte-10qvzzo"><div class="rates__card--values svelte-10qvzzo"><h3 class="values__title--mobile">DPE Dale Harper</h3></div></section></div></div>`;
        },
        title: () => {
          return `<span slot="title" data-svelte-h="svelte-ft6y7x">Designated Pilot Examiners</span>`;
        }
      })} ${validate_component(Roadmap, "Roadmap").$$render($$result, { stages }, {}, {})} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main"${add_styles({ "font-family": `inherit` })}><div class="topContainer svelte-10qvzzo"><section class="rates__card blue svelte-10qvzzo"><div class="rates__card--icon margin svelte-10qvzzo">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { width: "100%", color: "#0e76bc" }, {}, {})}</div> <div class="rates__card--values svelte-10qvzzo" data-svelte-h="svelte-17jgv6q"><h3 class="values__title--mobile">Private Pilot</h3> <p class="values__price svelte-10qvzzo">35hrs</p></div></section> <div class="adders svelte-10qvzzo">${validate_component(Plus, "Plus").$$render($$result, { color: "#0e76bc", size: "5rem" }, {}, {})}</div> <section class="rates__card blue svelte-10qvzzo"><div class="rates__card--icon margin svelte-10qvzzo">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { width: "100%", color: "#0e76bc" }, {}, {})}</div> <div class="rates__card--values svelte-10qvzzo" data-svelte-h="svelte-16m054v"><h3 class="values__title--mobile">Instrument Rating</h3> <p class="values__price svelte-10qvzzo">35hrs</p></div></section> <div class="adders svelte-10qvzzo">${validate_component(Plus, "Plus").$$render($$result, { color: "#0e76bc", size: "5rem" }, {}, {})}</div> <section class="rates__card blue svelte-10qvzzo"><div class="rates__card--icon margin svelte-10qvzzo">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { width: "100%", color: "#0e76bc" }, {}, {})}</div> <div class="rates__card--values svelte-10qvzzo" data-svelte-h="svelte-14yr8fi"><h3 class="values__title--mobile">Commercial SEL</h3> <p class="values__price svelte-10qvzzo">120hrs</p></div></section> <div class="adders svelte-10qvzzo">${validate_component(Plus, "Plus").$$render($$result, { color: "#0e76bc", size: "5rem" }, {}, {})}</div> <section class="rates__card blue svelte-10qvzzo"><div class="rates__card--icon margin svelte-10qvzzo">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { width: "100%", color: "#0e76bc" }, {}, {})}</div> <div class="rates__card--values svelte-10qvzzo" data-svelte-h="svelte-10h90f7"><h3 class="values__title--mobile">Commercial MEL</h3> <p class="values__price svelte-10qvzzo">15hrs</p> <p class="values__price svelte-10qvzzo">(Optional)</p></div></section> <div class="adders svelte-10qvzzo">${validate_component(Equal, "Equal").$$render($$result, { color: "#0e76bc", size: "5rem" }, {}, {})}</div> <section class="rates__card blue svelte-10qvzzo"><div class="rates__card--icon svelte-10qvzzo">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { width: "100%", color: "#0e76bc" }, {}, {})}</div> <div class="rates__card--values svelte-10qvzzo" data-svelte-h="svelte-z21sit"><h3 class="values__title--mobile">Total</h3> <p class="values__price svelte-10qvzzo">205hrs</p> <hr class="separator svelte-10qvzzo"> <h3 class="values__title--mobile">Flight<br>Program</h3> <p class="values__price svelte-10qvzzo">$59,895.00</p> <hr class="separator svelte-10qvzzo"> <h3 class="values__title--mobile">Additional<br>Expenses</h3> <p class="values__price svelte-10qvzzo">$19,900.00</p></div></section></div></div>`;
        },
        title: () => {
          return `<span slot="title" data-svelte-h="svelte-tikn3k">The Pilot Program</span>`;
        }
      })}`;
    }
  })} ${validate_component(Included, "Included").$$render($$result, { dgca: true }, {}, {})} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-n9r3zf">At First Landings, we prioritize the comfort and well-being of our international
			students, ensuring they have access to quality housing that supports their academic
			journey and personal growth. Marden Ridge Apartments in Apopka, Florida, offers our
			students a premium living experience.
			<br> <br> <b>Comfortable and Modern Living</b> <br>
			Marden Ridge provides three-bedroom apartments, each thoughtfully designed with modern conveniences.
			Students can enjoy features such as in-unit washers and dryers, all-electric appliances,
			spacious walk-in closets, and double vanity sinks. The sleek wood tile flooring adds a touch
			of modern elegance, while the inclusion of solariums allows students to soak up the Florida
			sunshine right from their home.
			<br> <br> <b>Community Amenities for a Balanced Lifestyle</b> <br>
			The community at Marden Ridge is equipped with a variety of amenities that cater to both
			relaxation and active living. Students can unwind by the resort-style pool and sundeck or
			engage in recreational activities in the game room and theater room. The Life Fitness studio
			provides a convenient space for maintaining an active lifestyle, essential for balancing
			the demands of academic life.
			<br> <br> <b>Academic and Professional Support</b> <br>
			Understanding the importance of a conducive study environment, Marden Ridge offers facilities
			such as a conference room and business center, ideal for group studies, meetings, and quiet
			workspaces. These amenities help ensure that students have the necessary resources to excel
			academically.
			<br> <br> <b>Strategic Location</b> <br>
			Located just outside Orlando, Marden Ridge offers students easy access to major highways,
			making commutes around Central Florida convenient. This strategic location not only facilitates
			academic pursuits but also allows students to explore and enjoy the cultural and recreational
			activities that the region has to offer.
			<br> <br> <b>Comprehensive Services</b> <br>
			Marden Ridge goes above and beyond with additional amenities such as a Starbucks coffee bar,
			valet trash service, and extra storage options. These services are designed to enhance the
			day-to-day living experience, allowing students to focus more on their studies and personal
			growth.
			<br> <br> <b>Commitment to Accessibility and Safety</b> <br>
			Marden Ridge is committed to providing a safe and accessible living environment, ensuring
			all students feel secure and accommodated. Their high standards of accessibility are aligned
			with our institution&#39;s commitment to inclusivity.
			<br> <br> <b>Estimated Cost</b> <br>
			$800/month (7-months for the program)</div>`;
        },
        title: () => {
          return `<span slot="title" data-svelte-h="svelte-1kgxwx6">Housing</span>`;
        }
      })} ${validate_component(Masonry, "Masonry").$$render($$result, { maxColumns: 3, gap: "16px" }, {}, {
        default: () => {
          return `<div class="masonry__item svelte-10qvzzo" data-svelte-h="svelte-b1fnvs"><picture><source${add_attribute("srcset", "/_app/immutable/assets/gym.852a874d.avif 540w, /_app/immutable/assets/gym.8660666c.avif 768w, /_app/immutable/assets/gym.94b0d365.avif 1080w, /_app/immutable/assets/gym.df0e44bf.avif 1200w", 0)} sizes="min(450px, 100%)" type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/gym.38527645.webp 540w, /_app/immutable/assets/gym.ad37af7d.webp 768w, /_app/immutable/assets/gym.c21411ab.webp 1080w, /_app/immutable/assets/gym.a2e5b328.webp 1200w", 0)} sizes="min(450px, 100%)" type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/gym.13756b6a.png 540w, /_app/immutable/assets/gym.ab6684f6.png 768w, /_app/immutable/assets/gym.6f028c06.png 1080w, /_app/immutable/assets/gym.29ec2565.png 1200w", 0)} sizes="min(450px, 100%)" type="image/png"><img class="masonry__img svelte-10qvzzo" alt="" src="/_app/immutable/assets/gym.29ec2565.png" width="1200" height="650"></picture></div> <div class="masonry__item svelte-10qvzzo" data-svelte-h="svelte-47z566"><picture><source${add_attribute("srcset", "/_app/immutable/assets/lounge.9db0446c.avif 540w, /_app/immutable/assets/lounge.1dce045f.avif 768w, /_app/immutable/assets/lounge.89c0faee.avif 1080w, /_app/immutable/assets/lounge.9b686609.avif 1200w", 0)} sizes="min(450px, 100%)" type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/lounge.ed5c9973.webp 540w, /_app/immutable/assets/lounge.5e5b75df.webp 768w, /_app/immutable/assets/lounge.fb49d66e.webp 1080w, /_app/immutable/assets/lounge.e7b89f2a.webp 1200w", 0)} sizes="min(450px, 100%)" type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/lounge.e013fe18.png 540w, /_app/immutable/assets/lounge.fb9de688.png 768w, /_app/immutable/assets/lounge.af4982bb.png 1080w, /_app/immutable/assets/lounge.2f21b693.png 1200w", 0)} sizes="min(450px, 100%)" type="image/png"><img class="masonry__img svelte-10qvzzo" alt="" src="/_app/immutable/assets/lounge.2f21b693.png" width="1200" height="650"></picture></div> <div class="masonry__item svelte-10qvzzo" data-svelte-h="svelte-zoeckw"><picture><source${add_attribute("srcset", "/_app/immutable/assets/pool.4c53d849.avif 540w, /_app/immutable/assets/pool.5df15af1.avif 768w, /_app/immutable/assets/pool.6b468df4.avif 1080w, /_app/immutable/assets/pool.9e92d65b.avif 1200w", 0)} sizes="min(450px, 100%)" type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/pool.9d5a9e42.webp 540w, /_app/immutable/assets/pool.20552c52.webp 768w, /_app/immutable/assets/pool.cbe39cd5.webp 1080w, /_app/immutable/assets/pool.c2355c1e.webp 1200w", 0)} sizes="min(450px, 100%)" type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/pool.5488e401.png 540w, /_app/immutable/assets/pool.0815e71b.png 768w, /_app/immutable/assets/pool.258a0b60.png 1080w, /_app/immutable/assets/pool.52efb2f6.png 1200w", 0)} sizes="min(450px, 100%)" type="image/png"><img class="masonry__img svelte-10qvzzo" alt="" src="/_app/immutable/assets/pool.52efb2f6.png" width="1200" height="650"></picture></div> <div class="masonry__item svelte-10qvzzo" data-svelte-h="svelte-1b18ztx"><picture><source${add_attribute("srcset", "/_app/immutable/assets/barbi.989523d1.avif 540w, /_app/immutable/assets/barbi.507fe7b7.avif 640w", 0)} sizes="min(450px, 100%)" type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/barbi.fb471bb9.webp 540w, /_app/immutable/assets/barbi.eded3628.webp 640w", 0)} sizes="min(450px, 100%)" type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/barbi.48490169.png 540w, /_app/immutable/assets/barbi.0c74441f.png 640w", 0)} sizes="min(450px, 100%)" type="image/png"><img class="masonry__img svelte-10qvzzo" alt="" src="/_app/immutable/assets/barbi.0c74441f.png" width="640" height="480"></picture></div> <div class="masonry__item svelte-10qvzzo" data-svelte-h="svelte-yqt34k"><picture><source${add_attribute("srcset", "/_app/immutable/assets/billiards.38f46f06.avif 540w, /_app/immutable/assets/billiards.108b56d2.avif 640w", 0)} sizes="min(450px, 100%)" type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/billiards.c2d381c0.webp 540w, /_app/immutable/assets/billiards.43d7d42c.webp 640w", 0)} sizes="min(450px, 100%)" type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/billiards.343ae34b.png 540w, /_app/immutable/assets/billiards.fcfdeffb.png 640w", 0)} sizes="min(450px, 100%)" type="image/png"><img class="masonry__img svelte-10qvzzo" alt="" src="/_app/immutable/assets/billiards.fcfdeffb.png" width="640" height="480"></picture></div>  <div class="masonry__item svelte-10qvzzo" data-svelte-h="svelte-1n3jldz"><picture><source${add_attribute("srcset", "/_app/immutable/assets/kitchen.6706446b.avif 540w, /_app/immutable/assets/kitchen.4cfd4cf5.avif 640w", 0)} sizes="min(450px, 100%)" type="image/avif"><source${add_attribute("srcset", "/_app/immutable/assets/kitchen.ccda5d23.webp 540w, /_app/immutable/assets/kitchen.b587edcc.webp 640w", 0)} sizes="min(450px, 100%)" type="image/webp"><source${add_attribute("srcset", "/_app/immutable/assets/kitchen.5865f623.png 540w, /_app/immutable/assets/kitchen.2b5cb90f.png 640w", 0)} sizes="min(450px, 100%)" type="image/png"><img class="masonry__img svelte-10qvzzo" alt="" src="/_app/immutable/assets/kitchen.2b5cb90f.png" width="640" height="480"></picture></div>`;
        }
      })}`;
    }
  })} ${validate_component(Reviews, "Reviews").$$render($$result, {}, {}, {})} ${validate_component(NehaContact, "NehaContact").$$render($$result, {}, {}, {})} <div class="content svelte-10qvzzo"><section class="content__info svelte-10qvzzo" data-svelte-h="svelte-9xywbe"><h3 class="content__info--title svelte-10qvzzo">Get in touch to learn more
			<hr class="seperator"></h3> <h2 class="content__info--subtitle svelte-10qvzzo">Contact us</h2> <p class="content__info--p svelte-10qvzzo">If you have any questions about our school and programs or would like to schedule a tour
			please give us a call or send us a message. We look forward to helping you realize your
			dreams of flight.</p></section> <section class="content__funnel svelte-10qvzzo"><h3 class="content__funnel--title svelte-10qvzzo" data-svelte-h="svelte-1b6df10">Contact one of our instructors today</h3> <p class="content__funnel--p svelte-10qvzzo" data-svelte-h="svelte-1r56qyi">Want to start exploring your flight training or career track in aviation? Reach out to
			us and one of our Training Advisors will address any inquiries you may have. We&#39;re are
			here to provide you with comprehensive insights and guide you through the exciting
			possibilities that aviation training and careers have to offer. Your aspirations are
			important to us, and we&#39;re committed to assisting you every step of the way.</p> <div class="content__funnel--button svelte-10qvzzo">${validate_component(Button, "Button").$$render($$result, { color: "orange", href: "/contact-us" }, {}, {
    default: () => {
      return `Contact Us Now`;
    }
  })}</div></section> </div>`;
});

export { Page as default };
//# sourceMappingURL=_page@.svelte-3af0b11b.js.map
