import fs from 'fs';
import path from 'path';

const POST = async ({ request }) => {
  try {
    const events = await request.json();
    const filePath = path.join(process.cwd(), "static", "events.json");
    fs.appendFileSync(filePath, JSON.stringify(events) + "\n");
    return new Response(JSON.stringify({ success: true }), {
      headers: { "Content-Type": "application/json" }
    });
  } catch (error) {
    return new Response(JSON.stringify({ success: false, error: error.message }), {
      status: 500,
      headers: { "Content-Type": "application/json" }
    });
  }
};

export { POST };
//# sourceMappingURL=_server.ts-7bfc563f.js.map
